/*
 * Decompiled with CFR 0.152.
 */
package ch.kronospace.tools;

import ch.kronospace.tools.CompressedFile;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class DiskTools {
    public static boolean debug = true;

    public static void copy(File source, File destination, boolean recursive) {
        if (!source.exists()) {
            return;
        }
        if (recursive && source.isDirectory()) {
            destination.mkdir();
            File[] liste = source.listFiles();
            int i = 0;
            while (i < liste.length) {
                DiskTools.copy(liste[i], new File(destination, liste[i].getName()), recursive);
                ++i;
            }
        } else {
            byte[] buffer = new byte[16384];
            try {
                FileInputStream in = new FileInputStream(source);
                FileOutputStream out = new FileOutputStream(destination);
                int nbr_car = in.read(buffer, 0, buffer.length);
                while (nbr_car != -1) {
                    out.write(buffer, 0, nbr_car);
                    nbr_car = in.read(buffer, 0, buffer.length);
                }
                out.close();
                in.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public static void copy(InputStream source, File destination) {
        byte[] buffer = new byte[16384];
        try {
            FileOutputStream out = new FileOutputStream(destination);
            int nbr_car = source.read(buffer, 0, buffer.length);
            while (nbr_car != -1) {
                out.write(buffer, 0, nbr_car);
                nbr_car = source.read(buffer, 0, buffer.length);
            }
            out.close();
            source.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void deltree(File dir) {
        if (!dir.exists()) {
            return;
        }
        File[] files = dir.listFiles();
        int i = 0;
        while (i < files.length) {
            File current_file = files[i];
            System.out.println(current_file);
            if (current_file.isDirectory()) {
                DiskTools.deltree(current_file);
            } else {
                current_file.delete();
            }
            ++i;
        }
        dir.delete();
    }

    public static boolean uncompressFile(File compressed_file, File out_directory) {
        if (!compressed_file.exists()) {
            throw new RuntimeException("could not find the file to uncompress: " + compressed_file.getAbsolutePath());
        }
        if (!out_directory.exists()) {
            out_directory.mkdir();
        }
        if (compressed_file.getName().endsWith(".zip") || compressed_file.getName().endsWith(".jar")) {
            try {
                ZipFile zf = new ZipFile(compressed_file);
                if (debug) {
                    System.out.println("Uncompressing " + compressed_file.getName() + " ...");
                }
                int nbr_files = zf.size();
                int i = 1;
                Enumeration<? extends ZipEntry> e = zf.entries();
                while (e.hasMoreElements()) {
                    ZipEntry ze = e.nextElement();
                    File out_file = new File(out_directory, ze.getName());
                    if (ze.isDirectory()) {
                        out_file.mkdir();
                    } else {
                        try {
                            InputStream in = zf.getInputStream(ze);
                            BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(out_file));
                            byte[] buffer = new byte[16384];
                            int n = in.read(buffer);
                            do {
                                out.write(buffer, 0, n);
                            } while ((n = in.read(buffer)) > 0);
                            in.close();
                            out.close();
                        }
                        catch (IOException e3) {
                            e3.printStackTrace();
                        }
                    }
                    if (!debug) continue;
                    System.out.print(String.valueOf(i * 100 / nbr_files) + "%\r");
                    ++i;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else {
            new CompressedFile(compressed_file).uncompressTo(out_directory);
        }
        return true;
    }
}

