/*
 * Decompiled with CFR 0.152.
 */
package ch.kronospace.tools;

import ch.kronospace.tools.FileChangeEvent;
import ch.kronospace.tools.FileChangeListener;
import ch.kronospace.tools.MonitoredFile;
import java.io.File;
import java.util.Enumeration;
import java.util.Vector;

public class FileChangeMonitor
extends Thread {
    private Vector files = new Vector();
    private long interval = 1000L;
    private boolean running = true;

    public FileChangeMonitor() {
        this.start();
    }

    public void addFileChangeListener(File f, FileChangeListener listener) {
        this.files.addElement(new MonitoredFile(f, listener));
    }

    public void removeFileChangeListener(FileChangeListener listener) {
        int i = 0;
        while (i < this.files.size()) {
            if (((MonitoredFile)this.files.elementAt((int)i)).listener == listener) {
                this.files.remove(i);
                break;
            }
            ++i;
        }
    }

    public void setInterval(long interval) {
        this.interval = interval;
    }

    public void checkFiles() {
        Enumeration e = this.files.elements();
        while (e.hasMoreElements()) {
            MonitoredFile mf = (MonitoredFile)e.nextElement();
            long last_modified = mf.f.lastModified();
            if (last_modified == mf.last_modified_date) continue;
            int type = 1;
            if (last_modified == 0L) {
                type = 2;
            }
            if (mf.last_modified_date == 0L) {
                type = 4;
            }
            mf.last_modified_date = last_modified;
            mf.listener.stateChanged(new FileChangeEvent(mf.f, type));
        }
    }

    public void stopMonitor() {
        this.running = false;
        this.interrupt();
    }

    public void startMonitor() {
        this.running = true;
        this.run();
    }

    public void run() {
        while (this.running) {
            this.checkFiles();
            try {
                FileChangeMonitor.sleep(this.interval);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

