/*
 * Decompiled with CFR 0.152.
 */
package ch.kronospace.tools;

import java.util.LinkedList;

public class ThreadPool {
    private PoolWorker[] threads;
    private LinkedList queue;
    private boolean running = true;
    public boolean debug = true;
    private boolean first_start = true;

    public ThreadPool(int nThreads, boolean start, boolean debug) {
        this.running = start;
        this.queue = new LinkedList();
        this.threads = new PoolWorker[nThreads];
        this.debug = debug;
        int i = 0;
        while (i < this.threads.length) {
            this.threads[i] = new PoolWorker(i);
            if (start) {
                this.threads[i].start();
            }
            ++i;
        }
        if (debug) {
            if (start) {
                System.out.println("ThreadPool created and started.");
            } else {
                System.out.println("ThreadPool created but not started.");
            }
        }
    }

    public ThreadPool(int nThreads, boolean start) {
        this(nThreads, start, false);
    }

    public void start() {
        if (this.running) {
            return;
        }
        this.running = true;
        if (this.debug) {
            System.out.println("ThreadPool started.");
        }
        int i = 0;
        while (i < this.threads.length) {
            if (!this.first_start) {
                this.threads[i] = new PoolWorker(i);
            }
            this.threads[i].start();
            ++i;
        }
        this.first_start = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(Runnable r) {
        LinkedList linkedList = this.queue;
        synchronized (linkedList) {
            if (this.debug) {
                System.out.println("Thread added: " + r.toString());
            }
            this.queue.addLast(r);
            this.queue.notify();
        }
    }

    public void stop(boolean wait_termination) {
        if (!this.running) {
            return;
        }
        this.running = false;
        if (this.debug) {
            System.out.println("Stopping the threadpool...");
        }
        int i = 0;
        while (i < this.threads.length) {
            this.execute(new Thread("LiberationThread"));
            ++i;
        }
        if (wait_termination) {
            this.internal_wait_termination();
        }
    }

    public void waitTermination() {
        if (!this.running) {
            return;
        }
        int i = 0;
        while (i < this.threads.length) {
            this.execute(new TerminationThread());
            ++i;
        }
        this.internal_wait_termination();
    }

    private void internal_wait_termination() {
        if (this.debug) {
            System.out.println("Attente de la fin des PoolWorkers...");
        }
        int i = 0;
        while (i < this.threads.length) {
            try {
                this.threads[i].join();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            ++i;
        }
        if (this.debug) {
            System.out.println("Attente de la fin des PoolWorkers terminee.");
            System.out.println("Taches non executees: " + this.queue.toString());
        }
    }

    private class PoolWorker
    extends Thread {
        int pool_worker_id;

        public PoolWorker(int pool_worker_id) {
            this.pool_worker_id = pool_worker_id;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Loose catch block
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void run() {
            if (ThreadPool.this.debug) {
                System.out.println("PoolWorker " + this.pool_worker_id + " started.");
            }
            while (ThreadPool.this.running) {
                Runnable r;
                block14: {
                    LinkedList linkedList = ThreadPool.this.queue;
                    synchronized (linkedList) {
                        while (true) {
                            while (true) {
                                if (!ThreadPool.this.queue.isEmpty()) {
                                    r = (Runnable)ThreadPool.this.queue.removeFirst();
                                    break block14;
                                }
                                if (ThreadPool.this.debug) {
                                    System.out.println("PoolWorker " + this.pool_worker_id + " waiting for work...");
                                }
                                try {
                                    ThreadPool.this.queue.wait();
                                }
                                catch (InterruptedException interruptedException) {
                                    // empty catch block
                                }
                            }
                            break;
                        }
                        catch (Throwable throwable) {
                            throw throwable;
                        }
                    }
                }
                try {
                    r.run();
                }
                catch (RuntimeException runtimeException) {
                    // empty catch block
                }
            }
            if (ThreadPool.this.debug) {
                System.out.println("PoolWorker " + this.pool_worker_id + " stopped.");
            }
        }
    }

    private class TerminationThread
    extends Thread {
        private TerminationThread() {
        }

        public void run() {
            ThreadPool.this.running = false;
        }

        public String toString() {
            return "TerminationThread";
        }
    }
}

