/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.jung.algorithms.cluster;

import edu.uci.ics.jung.algorithms.cluster.ClusterSet;
import edu.uci.ics.jung.algorithms.cluster.GraphClusterer;
import edu.uci.ics.jung.algorithms.cluster.VertexClusterSet;
import edu.uci.ics.jung.graph.ArchetypeGraph;
import edu.uci.ics.jung.graph.ArchetypeVertex;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.apache.commons.collections.buffer.UnboundedFifoBuffer;

public class WeakComponentClusterer
implements GraphClusterer {
    public ClusterSet extract(ArchetypeGraph aGraph) {
        VertexClusterSet clusterSet = new VertexClusterSet(aGraph);
        HashSet unvisitedVertices = new HashSet();
        Iterator vIt = aGraph.getVertices().iterator();
        while (vIt.hasNext()) {
            unvisitedVertices.add(vIt.next());
        }
        while (!unvisitedVertices.isEmpty()) {
            HashSet<ArchetypeVertex> weakComponentSet = new HashSet<ArchetypeVertex>();
            ArchetypeVertex root = (ArchetypeVertex)unvisitedVertices.iterator().next();
            unvisitedVertices.remove(root);
            weakComponentSet.add(root);
            UnboundedFifoBuffer queue = new UnboundedFifoBuffer();
            queue.add((Object)root);
            while (!queue.isEmpty()) {
                ArchetypeVertex currentVertex = (ArchetypeVertex)queue.remove();
                Set neighbors = currentVertex.getNeighbors();
                Iterator nIt = neighbors.iterator();
                while (nIt.hasNext()) {
                    ArchetypeVertex neighbor = (ArchetypeVertex)nIt.next();
                    if (!unvisitedVertices.contains(neighbor)) continue;
                    queue.add((Object)neighbor);
                    unvisitedVertices.remove(neighbor);
                    weakComponentSet.add(neighbor);
                }
            }
            clusterSet.addCluster(weakComponentSet);
        }
        return clusterSet;
    }
}

