/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.jung.graph.decorators;

import edu.uci.ics.jung.graph.DirectedEdge;
import edu.uci.ics.jung.graph.Edge;
import edu.uci.ics.jung.graph.decorators.AbstractEdgeShapeFunction;
import edu.uci.ics.jung.graph.predicates.SelfLoopEdgePredicate;
import edu.uci.ics.jung.utils.ParallelEdgeIndexFunction;
import edu.uci.ics.jung.visualization.ArrowFactory;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.CubicCurve2D;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.QuadCurve2D;
import org.apache.commons.collections.Predicate;

public class EdgeShape {
    protected static Loop loop = new Loop();
    protected static Predicate is_self_loop = SelfLoopEdgePredicate.getInstance();
    protected static SimpleLoop simpleLoop = new SimpleLoop();

    public static interface ParallelRendering {
        public void setParallelEdgeIndexFunction(ParallelEdgeIndexFunction var1);
    }

    public static class Wedge
    extends AbstractEdgeShapeFunction {
        private static GeneralPath triangle;
        private static GeneralPath bowtie;

        public Wedge(int width) {
            triangle = ArrowFactory.getWedgeArrow(width, 1.0f);
            triangle.transform(AffineTransform.getTranslateInstance(1.0, 0.0));
            bowtie = new GeneralPath(0);
            bowtie.moveTo(0.0f, width / 2);
            bowtie.lineTo(5.0f, -width / 2);
            bowtie.lineTo(5.0f, width / 2);
            bowtie.lineTo(0.0f, -width / 2);
            bowtie.closePath();
        }

        public Shape getShape(Edge e) {
            if (is_self_loop.evaluate((Object)e)) {
                return Loop.instance;
            }
            if (e instanceof DirectedEdge) {
                return triangle;
            }
            return bowtie;
        }
    }

    public static class Loop
    extends AbstractEdgeShapeFunction
    implements ParallelRendering {
        private static Ellipse2D instance = new Ellipse2D.Float();
        protected ParallelEdgeIndexFunction parallelEdgeIndexFunction;

        public void setParallelEdgeIndexFunction(ParallelEdgeIndexFunction parallelEdgeIndexFunction) {
            this.parallelEdgeIndexFunction = parallelEdgeIndexFunction;
        }

        public Shape getShape(Edge e) {
            int count = 1;
            if (this.parallelEdgeIndexFunction != null) {
                count = this.parallelEdgeIndexFunction.getIndex(e);
            }
            float x = -0.5f;
            float y = -0.5f;
            float diam = 1.0f;
            diam += diam * (float)count / 2.0f;
            x += x * (float)count / 2.0f;
            y += y * (float)count / 2.0f;
            instance.setFrame(x, y, diam, diam);
            return instance;
        }
    }

    public static class SimpleLoop
    extends AbstractEdgeShapeFunction {
        private static Ellipse2D instance = new Ellipse2D.Float(-0.5f, -0.5f, 1.0f, 1.0f);

        public Shape getShape(Edge e) {
            return instance;
        }
    }

    public static class CubicCurve
    extends AbstractEdgeShapeFunction
    implements ParallelRendering {
        private static CubicCurve2D instance = new CubicCurve2D.Float();
        protected ParallelEdgeIndexFunction parallelEdgeIndexFunction;

        public void setParallelEdgeIndexFunction(ParallelEdgeIndexFunction parallelEdgeIndexFunction) {
            this.parallelEdgeIndexFunction = parallelEdgeIndexFunction;
            loop.setParallelEdgeIndexFunction(parallelEdgeIndexFunction);
        }

        public Shape getShape(Edge e) {
            if (is_self_loop.evaluate((Object)e)) {
                return loop.getShape(e);
            }
            int index = 1;
            if (this.parallelEdgeIndexFunction != null) {
                index = this.parallelEdgeIndexFunction.getIndex(e);
            }
            float controlY = this.control_offset_increment + this.control_offset_increment * (float)index;
            instance.setCurve(0.0, 0.0, 0.33f, 2.0f * controlY, 0.66f, -controlY, 1.0, 0.0);
            return instance;
        }
    }

    public static class QuadCurve
    extends AbstractEdgeShapeFunction
    implements ParallelRendering {
        private static QuadCurve2D instance = new QuadCurve2D.Float();
        protected ParallelEdgeIndexFunction parallelEdgeIndexFunction;

        public void setParallelEdgeIndexFunction(ParallelEdgeIndexFunction parallelEdgeIndexFunction) {
            this.parallelEdgeIndexFunction = parallelEdgeIndexFunction;
            loop.setParallelEdgeIndexFunction(parallelEdgeIndexFunction);
        }

        public Shape getShape(Edge e) {
            if (is_self_loop.evaluate((Object)e)) {
                return loop.getShape(e);
            }
            int index = 1;
            if (this.parallelEdgeIndexFunction != null) {
                index = this.parallelEdgeIndexFunction.getIndex(e);
            }
            float controlY = this.control_offset_increment + this.control_offset_increment * (float)index;
            instance.setCurve(0.0, 0.0, 0.5, controlY, 1.0, 0.0);
            return instance;
        }
    }

    public static class BentLine
    extends AbstractEdgeShapeFunction
    implements ParallelRendering {
        private static GeneralPath instance = new GeneralPath();
        protected ParallelEdgeIndexFunction parallelEdgeIndexFunction;

        public void setParallelEdgeIndexFunction(ParallelEdgeIndexFunction parallelEdgeIndexFunction) {
            this.parallelEdgeIndexFunction = parallelEdgeIndexFunction;
            loop.setParallelEdgeIndexFunction(parallelEdgeIndexFunction);
        }

        public Shape getShape(Edge e) {
            if (is_self_loop.evaluate((Object)e)) {
                return loop.getShape(e);
            }
            int index = 1;
            if (this.parallelEdgeIndexFunction != null) {
                index = this.parallelEdgeIndexFunction.getIndex(e);
            }
            float controlY = this.control_offset_increment + this.control_offset_increment * (float)index;
            instance.reset();
            instance.moveTo(0.0f, 0.0f);
            instance.lineTo(0.5f, controlY);
            instance.lineTo(1.0f, 1.0f);
            return instance;
        }
    }

    public static class Line
    extends AbstractEdgeShapeFunction {
        private static Line2D instance = new Line2D.Float(0.0f, 0.0f, 1.0f, 0.0f);

        public Shape getShape(Edge e) {
            if (is_self_loop.evaluate((Object)e)) {
                return simpleLoop.getShape(e);
            }
            return instance;
        }
    }
}

