/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.jung.graph.decorators;

import edu.uci.ics.jung.graph.Vertex;
import edu.uci.ics.jung.graph.decorators.DefaultVertexIconFunction;
import edu.uci.ics.jung.graph.decorators.VertexShapeFunction;
import edu.uci.ics.jung.visualization.FourPassImageShaper;
import java.awt.Image;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.util.HashMap;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.ImageIcon;

public class VertexIconAndShapeFunction
extends DefaultVertexIconFunction
implements VertexShapeFunction {
    protected Map shapeMap = new HashMap();
    protected VertexShapeFunction delegate;

    public VertexIconAndShapeFunction(VertexShapeFunction delegate) {
        this.delegate = delegate;
    }

    public VertexShapeFunction getDelegate() {
        return this.delegate;
    }

    public void setDelegate(VertexShapeFunction delegate) {
        this.delegate = delegate;
    }

    public Shape getShape(Vertex v) {
        Icon icon = this.getIcon(v);
        if (icon != null && icon instanceof ImageIcon) {
            Image image = ((ImageIcon)icon).getImage();
            Shape shape = (Shape)this.shapeMap.get(image);
            if (shape == null) {
                shape = FourPassImageShaper.getShape(image, 30);
                int width = image.getWidth(null);
                int height = image.getHeight(null);
                AffineTransform transform = AffineTransform.getTranslateInstance(-width / 2, -height / 2);
                shape = transform.createTransformedShape(shape);
                this.shapeMap.put(image, shape);
            }
            return shape;
        }
        return this.delegate.getShape(v);
    }
}

