/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.jung.io;

import edu.uci.ics.jung.exceptions.FatalException;
import edu.uci.ics.jung.graph.ArchetypeVertex;
import edu.uci.ics.jung.graph.Edge;
import edu.uci.ics.jung.graph.Graph;
import edu.uci.ics.jung.graph.Vertex;
import edu.uci.ics.jung.graph.decorators.StringLabeller;
import edu.uci.ics.jung.graph.impl.DirectedSparseGraph;
import edu.uci.ics.jung.graph.impl.SparseVertex;
import edu.uci.ics.jung.graph.impl.UndirectedSparseGraph;
import edu.uci.ics.jung.utils.GraphUtils;
import edu.uci.ics.jung.utils.UserData;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class GraphMLFileHandler
extends DefaultHandler {
    private Graph mGraph;
    private StringLabeller mLabeller;

    protected Graph getGraph() {
        return this.mGraph;
    }

    protected StringLabeller getLabeller() {
        return this.mLabeller;
    }

    private Map getAttributeMap(Attributes attrs) {
        HashMap<String, String> map = new HashMap<String, String>();
        if (attrs != null) {
            for (int i = 0; i < attrs.getLength(); ++i) {
                map.put(attrs.getQName(i), attrs.getValue(i));
            }
        }
        return map;
    }

    protected Edge createEdge(Map attributeMap) {
        if (this.mGraph == null) {
            throw new FatalException("Error parsing graph. Graph element must be specified before edge element.");
        }
        String sourceId = (String)attributeMap.remove("source");
        Vertex sourceVertex = this.mLabeller.getVertex(sourceId);
        String targetId = (String)attributeMap.remove("target");
        Vertex targetVertex = this.mLabeller.getVertex(targetId);
        Edge e = GraphUtils.addEdge(this.mGraph, sourceVertex, targetVertex);
        Iterator keyIt = attributeMap.keySet().iterator();
        while (keyIt.hasNext()) {
            Object key = keyIt.next();
            Object value = attributeMap.get(key);
            e.setUserDatum(key, value, UserData.SHARED);
        }
        return e;
    }

    protected void createGraph(Map attributeMap) {
        String edgeDefaultType = (String)attributeMap.remove("edgedefault");
        if (edgeDefaultType.equals("directed")) {
            this.mGraph = new DirectedSparseGraph();
        } else if (edgeDefaultType.equals("undirected")) {
            this.mGraph = new UndirectedSparseGraph();
        } else {
            throw new FatalException("Error parsing graph. Edge default type not specified.");
        }
        this.mLabeller = StringLabeller.getLabeller(this.mGraph);
        Iterator keyIt = attributeMap.keySet().iterator();
        while (keyIt.hasNext()) {
            Object key = keyIt.next();
            Object value = attributeMap.get(key);
            this.mGraph.setUserDatum(key, value, UserData.SHARED);
        }
    }

    protected ArchetypeVertex createVertex(Map attributeMap) {
        if (this.mGraph == null) {
            throw new FatalException("Error parsing graph. Graph element must be specified before node element.");
        }
        Vertex vertex = this.mGraph.addVertex(new SparseVertex());
        String idString = (String)attributeMap.remove("id");
        try {
            this.mLabeller.setLabel(vertex, idString);
        }
        catch (StringLabeller.UniqueLabelException ule) {
            throw new FatalException("Ids must be unique");
        }
        Iterator keyIt = attributeMap.keySet().iterator();
        while (keyIt.hasNext()) {
            Object key = keyIt.next();
            Object value = attributeMap.get(key);
            vertex.setUserDatum(key, value, UserData.SHARED);
        }
        return vertex;
    }

    public void startElement(String namespaceURI, String lName, String qName, Attributes attrs) throws SAXException {
        Map attributeMap = this.getAttributeMap(attrs);
        if (qName.toLowerCase().equals("graph")) {
            this.createGraph(attributeMap);
        } else if (qName.toLowerCase().equals("node")) {
            this.createVertex(attributeMap);
        } else if (qName.toLowerCase().equals("edge")) {
            this.createEdge(attributeMap);
        }
    }
}

