/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.jung.utils;

import edu.uci.ics.jung.exceptions.FatalException;
import edu.uci.ics.jung.graph.Edge;
import edu.uci.ics.jung.graph.Graph;
import edu.uci.ics.jung.graph.Vertex;
import edu.uci.ics.jung.graph.decorators.EdgeWeightLabeller;
import edu.uci.ics.jung.graph.decorators.Indexer;
import edu.uci.ics.jung.graph.decorators.NumberEdgeValue;
import edu.uci.ics.jung.graph.decorators.StringLabeller;
import edu.uci.ics.jung.graph.impl.AbstractSparseEdge;
import edu.uci.ics.jung.graph.impl.AbstractSparseGraph;
import edu.uci.ics.jung.graph.impl.DirectedSparseEdge;
import edu.uci.ics.jung.graph.impl.DirectedSparseGraph;
import edu.uci.ics.jung.graph.impl.SparseGraph;
import edu.uci.ics.jung.graph.impl.SparseVertex;
import edu.uci.ics.jung.graph.impl.UndirectedSparseEdge;
import edu.uci.ics.jung.graph.impl.UndirectedSparseGraph;
import edu.uci.ics.jung.graph.impl.UndirectedSparseVertex;
import edu.uci.ics.jung.random.generators.BarabasiAlbertGenerator;
import edu.uci.ics.jung.utils.GraphUtils;
import edu.uci.ics.jung.utils.HashSettableVertexMapper;
import edu.uci.ics.jung.utils.UserData;
import java.util.HashSet;
import java.util.Iterator;

public class TestGraphs {
    public static String[][] pairs = new String[][]{{"a", "b", "3"}, {"a", "c", "4"}, {"a", "d", "5"}, {"d", "c", "6"}, {"d", "e", "7"}, {"e", "f", "8"}, {"f", "g", "9"}, {"h", "i", "1"}};

    public static AbstractSparseGraph createTestGraph(boolean isDirected) {
        SparseGraph g = isDirected ? new DirectedSparseGraph() : new UndirectedSparseGraph();
        StringLabeller sl = StringLabeller.getLabeller(g);
        EdgeWeightLabeller el = EdgeWeightLabeller.getLabeller(g);
        for (int i = 0; i < pairs.length; ++i) {
            String[] pair = pairs[i];
            TestGraphs.createEdge(g, sl, el, pair[0], pair[1], Integer.parseInt(pair[2]));
        }
        return g;
    }

    public static Graph createChainPlusIsolates(int chain_length, int isolate_count) {
        UndirectedSparseGraph g = new UndirectedSparseGraph();
        if (chain_length > 0) {
            Vertex[] v = new Vertex[chain_length];
            v[0] = g.addVertex(new UndirectedSparseVertex());
            for (int i = 1; i < chain_length; ++i) {
                v[i] = g.addVertex(new UndirectedSparseVertex());
                g.addEdge(new UndirectedSparseEdge(v[i], v[i - 1]));
            }
        }
        for (int i = 0; i < isolate_count; ++i) {
            g.addVertex(new UndirectedSparseVertex());
        }
        return g;
    }

    public static Graph createDirectedAcyclicGraph(int layers, int maxNodesPerLayer, double linkprob) {
        DirectedSparseGraph dag = new DirectedSparseGraph();
        StringLabeller sl = StringLabeller.getLabeller(dag);
        HashSet previousLayers = new HashSet();
        HashSet<Vertex> inThisLayer = new HashSet<Vertex>();
        for (int i = 0; i < layers; ++i) {
            int nodesThisLayer = (int)(Math.random() * (double)maxNodesPerLayer) + 1;
            for (int j = 0; j < nodesThisLayer; ++j) {
                Vertex v = dag.addVertex(new SparseVertex());
                inThisLayer.add(v);
                try {
                    sl.setLabel(v, i + ":" + j);
                }
                catch (Exception e) {
                    // empty catch block
                }
                Iterator iter = previousLayers.iterator();
                while (iter.hasNext()) {
                    Vertex v2 = (Vertex)iter.next();
                    if (!(Math.random() < linkprob)) continue;
                    GraphUtils.addEdge(dag, v, v2);
                }
            }
            previousLayers.addAll(inThisLayer);
            inThisLayer.clear();
        }
        return dag;
    }

    private static void createEdge(AbstractSparseGraph g, StringLabeller sl, EdgeWeightLabeller el, String v1Label, String v2Label, int weight) {
        try {
            Vertex v2;
            Vertex v1 = sl.getVertex(v1Label);
            if (v1 == null) {
                v1 = g.addVertex(new SparseVertex());
                sl.setLabel(v1, v1Label);
            }
            if ((v2 = sl.getVertex(v2Label)) == null) {
                v2 = g.addVertex(new SparseVertex());
                sl.setLabel(v2, v2Label);
            }
            Edge e = GraphUtils.addEdge(g, v1, v2);
            el.setWeight(e, weight);
        }
        catch (StringLabeller.UniqueLabelException e) {
            throw new FatalException("This should not happen " + e);
        }
    }

    public static Graph getOneComponentGraph() {
        String i2;
        String i1;
        int j;
        int i;
        UndirectedSparseGraph g = new UndirectedSparseGraph();
        StringLabeller sl = StringLabeller.getLabeller(g);
        EdgeWeightLabeller el = EdgeWeightLabeller.getLabeller(g);
        for (i = 1; i <= 10; ++i) {
            for (j = i + 1; j <= 10; ++j) {
                i1 = "" + i;
                i2 = "" + j;
                TestGraphs.createEdge(g, sl, el, i1, i2, i + j);
            }
        }
        for (i = 11; i <= 20; ++i) {
            for (j = i + 1; j <= 20; ++j) {
                if (Math.random() > 0.6) continue;
                i1 = "" + i;
                i2 = "" + j;
                TestGraphs.createEdge(g, sl, el, i1, i2, i + j);
            }
        }
        Indexer ind = Indexer.getIndexer(g);
        for (int i3 = 0; i3 < g.numVertices() - 1; ++i3) {
            try {
                GraphUtils.addEdge(g, (Vertex)ind.getVertex(i3), (Vertex)ind.getVertex(i3 + 1));
                continue;
            }
            catch (IllegalArgumentException fe) {
                // empty catch block
            }
        }
        return g;
    }

    public static Graph getDemoGraph() {
        String i2;
        String i1;
        int i;
        UndirectedSparseGraph g = new UndirectedSparseGraph();
        StringLabeller sl = StringLabeller.getLabeller(g);
        EdgeWeightLabeller el = EdgeWeightLabeller.getLabeller(g);
        for (i = 0; i < pairs.length; ++i) {
            String[] pair = pairs[i];
            TestGraphs.createEdge(g, sl, el, pair[0], pair[1], Integer.parseInt(pair[2]));
        }
        for (i = 1; i <= 10; ++i) {
            for (int j = i + 1; j <= 10; ++j) {
                i1 = "" + i;
                i2 = "" + j;
                TestGraphs.createEdge(g, sl, el, i1, i2, i + j);
            }
        }
        for (i = 11; i <= 20; ++i) {
            for (int j = i + 1; j <= 20; ++j) {
                if (Math.random() > 0.6) continue;
                i1 = "" + i;
                i2 = "" + j;
                TestGraphs.createEdge(g, sl, el, i1, i2, i + j);
            }
        }
        return g;
    }

    public static Graph generateMixedRandomGraph(NumberEdgeValue edge_weight, int num_vertices) {
        return TestGraphs.generateMixedRandomGraph(edge_weight, num_vertices, true);
    }

    public static Graph generateMixedRandomGraph(NumberEdgeValue edge_weights, int num_vertices, boolean parallel) {
        int seed = (int)(Math.random() * 10000.0);
        BarabasiAlbertGenerator bag = new BarabasiAlbertGenerator(4, 3, false, parallel, seed);
        bag.evolveGraph(num_vertices - 4);
        Graph ug = (Graph)bag.generateGraph();
        HashSettableVertexMapper svm = new HashSettableVertexMapper();
        SparseGraph g = new SparseGraph();
        Iterator iter = ug.getVertices().iterator();
        while (iter.hasNext()) {
            Vertex v = (Vertex)iter.next();
            SparseVertex w = new SparseVertex();
            g.addVertex(w);
            if (v.containsUserDatumKey(BarabasiAlbertGenerator.SEED)) {
                w.addUserDatum(BarabasiAlbertGenerator.SEED, BarabasiAlbertGenerator.SEED, UserData.REMOVE);
            }
            svm.map(v, w);
        }
        iter = ug.getEdges().iterator();
        while (iter.hasNext()) {
            Edge e = (Edge)iter.next();
            Vertex v1 = (Vertex)e.getEndpoints().getFirst();
            Vertex v2 = (Vertex)e.getEndpoints().getSecond();
            Vertex mv1 = (Vertex)svm.getMappedVertex(v1);
            Vertex mv2 = (Vertex)svm.getMappedVertex(v2);
            AbstractSparseEdge me = Math.random() < 0.5 ? new DirectedSparseEdge(mv1, mv2) : new UndirectedSparseEdge(mv1, mv2);
            g.addEdge(me);
            edge_weights.setNumber(me, new Double(Math.random()));
        }
        return g;
    }
}

