/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.jung.visualization;

import edu.uci.ics.jung.visualization.Layout;
import edu.uci.ics.jung.visualization.VisualizationViewer;
import edu.uci.ics.jung.visualization.transform.MutableTransformer;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.geom.AffineTransform;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.beans.PropertyChangeSupport;

public class Lens
extends Rectangle2D.Float
implements MouseListener,
MouseMotionListener {
    protected boolean pan;
    protected boolean dragRightLeg;
    protected boolean dragBase;
    protected boolean dragLeftLeg;
    protected boolean dragTop;
    protected boolean outside;
    protected float offx;
    protected float offy;
    protected Line2D leftLeg;
    protected Line2D rightLeg;
    protected Line2D base;
    protected Line2D top;
    protected float scalex;
    protected float scaley;
    protected Layout layout;
    protected VisualizationViewer vv;
    protected PropertyChangeSupport support;
    protected float aspectRatio;
    protected Point down;
    protected AffineTransform lensXform;

    public Lens(VisualizationViewer vv, float scalex, float scaley) {
        super((float)vv.getGraphLayout().getCurrentSize().width * scalex / 4.0f, (float)vv.getGraphLayout().getCurrentSize().height * scaley / 4.0f, (float)vv.getGraphLayout().getCurrentSize().width * scalex / 2.0f, (float)vv.getGraphLayout().getCurrentSize().height * scaley / 2.0f);
        this.vv = vv;
        this.layout = vv.getGraphLayout();
        this.scalex = scalex;
        this.scaley = scaley;
        this.lensXform = AffineTransform.getScaleInstance(1.0f / scalex, 1.0f / scaley);
        this.aspectRatio = (float)((this.getMaxX() - this.getMinX()) / (this.getMaxY() - this.getMinY()));
        this.rightLeg = new Line2D.Float((float)this.getMaxX(), (float)this.getMinY(), (float)this.getMaxX(), (float)this.getMaxY());
        this.leftLeg = new Line2D.Float((float)this.getMinX(), (float)this.getMinY(), (float)this.getMinX(), (float)this.getMaxY());
        this.base = new Line2D.Float((float)this.getMinX(), (float)this.getMaxY(), (float)this.getMaxX(), (float)this.getMaxY());
        this.top = new Line2D.Float((float)this.getMinX(), (float)this.getMinY(), (float)this.getMaxX(), (float)this.getMinY());
    }

    public void reset() {
        Dimension d = this.vv.getSize();
        Dimension ld = this.vv.getGraphLayout().getCurrentSize();
        this.vv.getViewTransformer().setScale((float)d.width / (float)ld.width, (float)d.height / (float)ld.height, new Point2D.Float());
    }

    public void setFrame(VisualizationViewer vv) {
        MutableTransformer viewTransformer = vv.getViewTransformer();
        Dimension d = new Dimension((int)((float)vv.getSize().width * this.scalex), (int)((float)vv.getSize().height * this.scaley));
        float width = (float)((double)d.width / viewTransformer.getScaleX());
        float height = (float)((double)d.height / viewTransformer.getScaleY());
        float x = -((float)(viewTransformer.getTranslateX() * (double)this.scalex / viewTransformer.getScaleX()));
        float y = -((float)(viewTransformer.getTranslateY() * (double)this.scaley / viewTransformer.getScaleY()));
        this.setFrame(x, y, width, height);
    }

    public void init() {
        this.vv.getViewTransformer().setScale(2.0, 2.0, this.vv.getCenter());
    }

    public void mouseClicked(MouseEvent e) {
    }

    public void mousePressed(MouseEvent e) {
        this.down = e.getPoint();
        if (this.leftLeg.ptLineDist(this.down) < 5.0) {
            this.dragLeftLeg = true;
        } else if (this.rightLeg.ptLineDist(this.down) < 5.0) {
            this.dragRightLeg = true;
        } else if (this.base.ptLineDist(this.down) < 5.0) {
            this.dragBase = true;
        } else if (this.top.ptLineDist(this.down) < 5.0) {
            this.dragTop = true;
        } else if (this.contains(this.down)) {
            this.pan = true;
        } else {
            this.dragTop = false;
            this.dragBase = false;
            this.dragRightLeg = false;
            this.dragLeftLeg = false;
            this.pan = false;
        }
    }

    public void mouseReleased(MouseEvent e) {
        this.dragBase = false;
        this.dragTop = false;
        this.dragRightLeg = false;
        this.dragLeftLeg = false;
        this.pan = false;
    }

    public void mouseEntered(MouseEvent e) {
        this.outside = false;
    }

    public void mouseExited(MouseEvent e) {
        this.outside = true;
    }

    public void mouseDragged(MouseEvent e) {
        if (this.outside) {
            return;
        }
        Point q = this.down;
        Point p = e.getPoint();
        if (this.pan) {
            this.vv.getViewTransformer().translate((((Point2D)q).getX() - ((Point2D)p).getX()) / (double)this.scalex, (((Point2D)q).getY() - ((Point2D)p).getY()) / (double)this.scaley);
        } else {
            float dw = 0.0f;
            float dh = 0.0f;
            if (this.dragRightLeg) {
                dw = (float)(((Point2D)p).getX() - ((Point2D)q).getX());
                dh = dw / this.aspectRatio;
            } else if (this.dragLeftLeg) {
                dw = (float)(((Point2D)q).getX() - ((Point2D)p).getX());
                dh = dw / this.aspectRatio;
            } else if (this.dragBase) {
                dh = (float)(((Point2D)p).getY() - ((Point2D)q).getY());
                dw = dh * this.aspectRatio;
            } else if (this.dragTop) {
                dh = (float)(((Point2D)q).getY() - ((Point2D)p).getY());
                dw = dh * this.aspectRatio;
            }
            float pwidth = (float)this.getMaxX() - (float)this.getMinX();
            float pheight = (float)this.getMaxY() - (float)this.getMinY();
            float newWidth = pwidth + 2.0f * dw;
            float newHeight = pheight + 2.0f * dh;
            if (newWidth < 3.0f || newHeight < 3.0f) {
                return;
            }
            this.vv.getViewTransformer().scale(pwidth / newWidth, pheight / newHeight, this.vv.getCenter());
        }
        this.down = e.getPoint();
        this.rightLeg = new Line2D.Float((float)this.getMaxX(), (float)this.getMinY(), (float)this.getMaxX(), (float)this.getMaxY());
        this.leftLeg = new Line2D.Float((float)this.getMinX(), (float)this.getMinY(), (float)this.getMinX(), (float)this.getMaxY());
        this.base = new Line2D.Float((float)this.getMinX(), (float)this.getMaxY(), (float)this.getMaxX(), (float)this.getMaxY());
        this.top = new Line2D.Float((float)this.getMinX(), (float)this.getMinY(), (float)this.getMaxX(), (float)this.getMinY());
    }

    public void mouseMoved(MouseEvent e) {
    }
}

