/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.jung.visualization;

import edu.uci.ics.jung.graph.Edge;
import edu.uci.ics.jung.graph.Vertex;
import edu.uci.ics.jung.visualization.Layout;
import edu.uci.ics.jung.visualization.PickSupport;
import edu.uci.ics.jung.visualization.PickedState;
import edu.uci.ics.jung.visualization.VisualizationViewer;
import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.awt.geom.Point2D;
import javax.swing.SwingUtilities;

public class SimpleGraphMouse
extends MouseAdapter
implements VisualizationViewer.GraphMouse {
    protected VisualizationViewer vv;
    protected float offsetx;
    protected float offsety;
    protected Vertex vertexToDrag;

    public SimpleGraphMouse(VisualizationViewer vv) {
        this.vv = vv;
    }

    public void mousePressed(MouseEvent e) {
        PickSupport pickSupport = this.vv.getPickSupport();
        PickedState pickedState = this.vv.getPickedState();
        if (pickSupport != null && pickedState != null) {
            Layout layout = this.vv.getGraphLayout();
            if (SwingUtilities.isLeftMouseButton(e)) {
                Point p = e.getPoint();
                Point2D gp = this.vv.inverseTransform(p);
                Vertex v = pickSupport.getVertex(gp.getX(), gp.getY());
                if (v != null) {
                    pickedState.clearPickedVertices();
                    pickedState.pick(v, true);
                    this.vertexToDrag = v;
                    Point2D q = layout.getLocation(v);
                    Point2D gq = this.vv.getLayoutTransformer().inverseTransform(q);
                    this.offsetx = (float)(gp.getX() - gq.getX());
                    this.offsety = (float)(gp.getY() - gq.getY());
                } else {
                    Edge edge = pickSupport.getEdge(gp.getX(), gp.getY());
                    if (edge != null) {
                        pickedState.clearPickedEdges();
                        pickedState.pick(edge, true);
                    }
                }
                this.vv.repaint();
            } else if (SwingUtilities.isMiddleMouseButton(e)) {
                Point2D p = this.vv.inverseTransform(e.getPoint());
                Vertex v = pickSupport.getVertex(p.getX(), p.getY());
                if (v != null) {
                    boolean wasThere = pickedState.pick(v, !pickedState.isPicked(v));
                    if (wasThere) {
                        this.vertexToDrag = null;
                    } else {
                        this.vertexToDrag = v;
                        Point2D point = this.vv.getLayoutTransformer().inverseTransform(layout.getLocation(v));
                        this.offsetx = (float)(p.getX() - point.getX());
                        this.offsety = (float)(p.getY() - point.getY());
                    }
                } else {
                    Edge edge = pickSupport.getEdge(p.getX(), p.getY());
                    if (edge != null) {
                        pickedState.pick(edge, !pickedState.isPicked(edge));
                    }
                }
                this.vv.repaint();
            }
        }
    }

    public void mouseReleased(MouseEvent e) {
        this.vertexToDrag = null;
    }

    public void mouseDragged(MouseEvent e) {
        if (this.vertexToDrag != null) {
            Point2D p = this.vv.inverseTransform(e.getPoint());
            Layout layout = this.vv.getGraphLayout();
            layout.forceMove(this.vertexToDrag, p.getX() - (double)this.offsetx, p.getY() - (double)this.offsety);
            this.vv.repaint();
        }
    }

    public void mouseMoved(MouseEvent e) {
    }

    public void mouseWheelMoved(MouseWheelEvent e) {
    }
}

