/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.jung.visualization;

import edu.uci.ics.jung.graph.Edge;
import edu.uci.ics.jung.graph.Graph;
import edu.uci.ics.jung.graph.Vertex;
import edu.uci.ics.jung.utils.Pair;
import edu.uci.ics.jung.utils.UserData;
import edu.uci.ics.jung.visualization.AbstractLayout;
import edu.uci.ics.jung.visualization.Coordinates;
import edu.uci.ics.jung.visualization.LayoutMutable;
import java.awt.Dimension;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.geom.Point2D;
import java.util.ConcurrentModificationException;
import java.util.Iterator;

public class SpringLayout
extends AbstractLayout
implements LayoutMutable {
    private static final Object SPRING_KEY = "temp_edu.uci.ics.jung.Spring_Visualization_Key";
    protected double stretch = 0.7;
    protected LengthFunction lengthFunction;
    protected int repulsion_range = 100;
    protected double force_multiplier = 0.3333333333333333;
    Object key = null;
    public static final LengthFunction UNITLENGTHFUNCTION = new UnitLengthFunction(30);

    public String getStatus() {
        return null;
    }

    public SpringLayout(Graph g) {
        this(g, UNITLENGTHFUNCTION);
    }

    public SpringLayout(Graph g, LengthFunction f) {
        super(g);
        this.lengthFunction = f;
    }

    public double getStretch() {
        return this.stretch;
    }

    public void setStretch(double stretch) {
        this.stretch = stretch;
    }

    public int getRepulsionRange() {
        return this.repulsion_range;
    }

    public void setRepulsionRange(int range) {
        this.repulsion_range = range;
    }

    public double getForceMultiplier() {
        return this.force_multiplier;
    }

    public void setForceMultiplier(double force) {
        this.force_multiplier = force;
    }

    protected void initialize_local() {
        try {
            Iterator iter = this.getGraph().getEdges().iterator();
            while (iter.hasNext()) {
                Edge e = (Edge)iter.next();
                SpringEdgeData sed = this.getSpringData(e);
                if (sed == null) {
                    sed = new SpringEdgeData(e);
                    e.addUserDatum(this.getSpringKey(), sed, UserData.REMOVE);
                }
                this.calcEdgeLength(sed, this.lengthFunction);
            }
        }
        catch (ConcurrentModificationException cme) {
            this.initialize_local();
        }
    }

    public Object getSpringKey() {
        if (this.key == null) {
            this.key = new Pair(this, SPRING_KEY);
        }
        return this.key;
    }

    protected void initialize_local_vertex(Vertex v) {
        SpringVertexData vud = this.getSpringData(v);
        if (vud == null) {
            vud = new SpringVertexData();
            v.addUserDatum(this.getSpringKey(), vud, UserData.REMOVE);
        }
    }

    protected void calcEdgeLength(SpringEdgeData sed, LengthFunction f) {
        sed.length = f.getLength(sed.e);
    }

    public void advancePositions() {
        try {
            Iterator iter = this.getVisibleVertices().iterator();
            while (iter.hasNext()) {
                Vertex v = (Vertex)iter.next();
                SpringVertexData svd = this.getSpringData(v);
                if (svd == null) continue;
                svd.dx /= 4.0;
                svd.dy /= 4.0;
                svd.edgedy = 0.0;
                svd.edgedx = 0.0;
                svd.repulsiondy = 0.0;
                svd.repulsiondx = 0.0;
            }
        }
        catch (ConcurrentModificationException cme) {
            this.advancePositions();
        }
        this.relaxEdges();
        this.calculateRepulsion();
        this.moveNodes();
    }

    protected Vertex getAVertex(Edge e) {
        Vertex v = (Vertex)e.getIncidentVertices().iterator().next();
        return v;
    }

    protected void relaxEdges() {
        try {
            Iterator i = this.getVisibleEdges().iterator();
            while (i.hasNext()) {
                Edge e = (Edge)i.next();
                Vertex v1 = this.getAVertex(e);
                Vertex v2 = e.getOpposite(v1);
                Point2D p1 = this.getLocation(v1);
                Point2D p2 = this.getLocation(v2);
                if (p1 == null || p2 == null) continue;
                double vx = p1.getX() - p2.getX();
                double vy = p1.getY() - p2.getY();
                double len = Math.sqrt(vx * vx + vy * vy);
                double desiredLen = this.getLength(e);
                len = len == 0.0 ? 1.0E-4 : len;
                double f = this.force_multiplier * (desiredLen - len) / len;
                double dx = (f *= Math.pow(this.stretch, v1.degree() + v2.degree() - 2)) * vx;
                double dy = f * vy;
                SpringVertexData v1D = this.getSpringData(v1);
                SpringVertexData v2D = this.getSpringData(v2);
                SpringEdgeData sed = this.getSpringData(e);
                sed.f = f;
                v1D.edgedx += dx;
                v1D.edgedy += dy;
                v2D.edgedx += -dx;
                v2D.edgedy += -dy;
            }
        }
        catch (ConcurrentModificationException cme) {
            this.relaxEdges();
        }
    }

    protected void calculateRepulsion() {
        try {
            Iterator iter = this.getGraph().getVertices().iterator();
            while (iter.hasNext()) {
                Vertex v = (Vertex)iter.next();
                if (this.dontMove(v)) continue;
                SpringVertexData svd = this.getSpringData(v);
                double dx = 0.0;
                double dy = 0.0;
                Iterator iter2 = this.getGraph().getVertices().iterator();
                while (iter2.hasNext()) {
                    double vy;
                    Vertex v2 = (Vertex)iter2.next();
                    if (v == v2) continue;
                    Point2D p = this.getLocation(v);
                    Point2D p2 = this.getLocation(v2);
                    if (p == null || p2 == null) continue;
                    double vx = p.getX() - p2.getX();
                    double distance = vx * vx + (vy = p.getY() - p2.getY()) * vy;
                    if (distance == 0.0) {
                        dx += Math.random();
                        dy += Math.random();
                        continue;
                    }
                    if (!(distance < (double)(this.repulsion_range * this.repulsion_range))) continue;
                    double factor = 1.0;
                    dx += factor * vx / Math.pow(distance, 2.0);
                    dy += factor * vy / Math.pow(distance, 2.0);
                }
                double dlen = dx * dx + dy * dy;
                if (!(dlen > 0.0)) continue;
                dlen = Math.sqrt(dlen) / 2.0;
                svd.repulsiondx += dx / dlen;
                svd.repulsiondy += dy / dlen;
            }
        }
        catch (ConcurrentModificationException cme) {
            this.calculateRepulsion();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void moveNodes() {
        Dimension dimension = this.getCurrentSize();
        synchronized (dimension) {
            try {
                Iterator i = this.getVisibleVertices().iterator();
                while (i.hasNext()) {
                    SpringVertexData vd;
                    Vertex v = (Vertex)i.next();
                    if (this.dontMove(v) || (vd = this.getSpringData(v)) == null) continue;
                    Coordinates xyd = this.getCoordinates(v);
                    vd.dx += vd.repulsiondx + vd.edgedx;
                    vd.dy += vd.repulsiondy + vd.edgedy;
                    xyd.addX(Math.max(-5.0, Math.min(5.0, vd.dx)));
                    xyd.addY(Math.max(-5.0, Math.min(5.0, vd.dy)));
                    int width = this.getCurrentSize().width;
                    int height = this.getCurrentSize().height;
                    if (xyd.getX() < 0.0) {
                        xyd.setX(0.0);
                    } else if (xyd.getX() > (double)width) {
                        xyd.setX(width);
                    }
                    if (xyd.getY() < 0.0) {
                        xyd.setY(0.0);
                        continue;
                    }
                    if (!(xyd.getY() > (double)height)) continue;
                    xyd.setY(height);
                }
            }
            catch (ConcurrentModificationException cme) {
                this.moveNodes();
            }
        }
    }

    public SpringVertexData getSpringData(Vertex v) {
        return (SpringVertexData)v.getUserDatum(this.getSpringKey());
    }

    public SpringEdgeData getSpringData(Edge e) {
        try {
            return (SpringEdgeData)e.getUserDatum(this.getSpringKey());
        }
        catch (ClassCastException cce) {
            System.out.println(e.getUserDatum(this.getSpringKey()).getClass());
            throw cce;
        }
    }

    public double getLength(Edge e) {
        return ((SpringEdgeData)e.getUserDatum((Object)this.getSpringKey())).length;
    }

    public boolean isIncremental() {
        return true;
    }

    public boolean incrementsAreDone() {
        return false;
    }

    public void update() {
        try {
            Iterator iter = this.getGraph().getVertices().iterator();
            while (iter.hasNext()) {
                Vertex v = (Vertex)iter.next();
                Coordinates coord = (Coordinates)v.getUserDatum(this.getBaseKey());
                if (coord != null) continue;
                coord = new Coordinates();
                v.addUserDatum(this.getBaseKey(), coord, UserData.REMOVE);
                this.initializeLocation(v, coord, this.getCurrentSize());
                this.initialize_local_vertex(v);
            }
        }
        catch (ConcurrentModificationException cme) {
            this.update();
        }
        this.initialize_local();
    }

    public class SpringDimensionChecker
    extends ComponentAdapter {
        public void componentResized(ComponentEvent e) {
            SpringLayout.this.resize(e.getComponent().getSize());
        }
    }

    protected static class SpringEdgeData {
        public double f;
        Edge e;
        double length;

        public SpringEdgeData(Edge e) {
            this.e = e;
        }
    }

    protected static class SpringVertexData {
        public double edgedx;
        public double edgedy;
        public double repulsiondx;
        public double repulsiondy;
        public double dx;
        public double dy;
    }

    public static final class UnitLengthFunction
    implements LengthFunction {
        int length;

        public UnitLengthFunction(int length) {
            this.length = length;
        }

        public double getLength(Edge e) {
            return this.length;
        }
    }

    public static interface LengthFunction {
        public double getLength(Edge var1);
    }
}

