/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.jung.visualization.control;

import edu.uci.ics.jung.visualization.control.AbstractModalGraphMouse;
import edu.uci.ics.jung.visualization.control.AnimatedPickingGraphMousePlugin;
import edu.uci.ics.jung.visualization.control.CrossoverScalingGraphMousePlugin;
import edu.uci.ics.jung.visualization.control.LensMagnificationGraphMousePlugin;
import edu.uci.ics.jung.visualization.control.LensTranslatingGraphMousePlugin;
import edu.uci.ics.jung.visualization.control.ModalGraphMouse;
import edu.uci.ics.jung.visualization.control.PickingGraphMousePlugin;
import edu.uci.ics.jung.visualization.control.RotatingGraphMousePlugin;
import edu.uci.ics.jung.visualization.control.ShearingGraphMousePlugin;

public class ModalLensGraphMouse
extends AbstractModalGraphMouse
implements ModalGraphMouse {
    protected LensMagnificationGraphMousePlugin magnificationPlugin;

    public ModalLensGraphMouse() {
        this(1.1f, 0.9f);
    }

    public ModalLensGraphMouse(float in, float out) {
        this(in, out, new LensMagnificationGraphMousePlugin());
    }

    public ModalLensGraphMouse(LensMagnificationGraphMousePlugin magnificationPlugin) {
        this(1.1f, 0.9f, magnificationPlugin);
    }

    public ModalLensGraphMouse(float in, float out, LensMagnificationGraphMousePlugin magnificationPlugin) {
        this.in = in;
        this.out = out;
        this.magnificationPlugin = magnificationPlugin;
        this.loadPlugins();
    }

    protected void loadPlugins() {
        this.pickingPlugin = new PickingGraphMousePlugin();
        this.animatedPickingPlugin = new AnimatedPickingGraphMousePlugin();
        this.translatingPlugin = new LensTranslatingGraphMousePlugin(16);
        this.scalingPlugin = new CrossoverScalingGraphMousePlugin(this.in, this.out);
        this.rotatingPlugin = new RotatingGraphMousePlugin();
        this.shearingPlugin = new ShearingGraphMousePlugin();
        this.add(this.magnificationPlugin);
        this.add(this.scalingPlugin);
        this.setMode(ModalGraphMouse.Mode.TRANSFORMING);
    }
}

