/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.jung.visualization.transform;

import edu.uci.ics.jung.visualization.VisualizationViewer;
import edu.uci.ics.jung.visualization.control.ModalGraphMouse;
import edu.uci.ics.jung.visualization.transform.LensSupport;
import edu.uci.ics.jung.visualization.transform.LensTransformer;
import edu.uci.ics.jung.visualization.transform.MutableTransformer;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.geom.Ellipse2D;

public abstract class AbstractLensSupport
implements LensSupport {
    protected VisualizationViewer vv;
    protected VisualizationViewer.GraphMouse graphMouse;
    protected MutableTransformer savedViewTransformer;
    protected LensTransformer lensTransformer;
    protected ModalGraphMouse lensGraphMouse;
    protected Lens lens;
    protected LensControls lensControls;
    protected String defaultToolTipText;
    protected static final String instructions = "<html><center>Mouse-Drag the Lens center to move it<p>Mouse-Drag the Lens edge to resize it<p>Ctrl+MouseWheel to change magnification</center></html>";

    public AbstractLensSupport(VisualizationViewer vv, ModalGraphMouse lensGraphMouse) {
        this.vv = vv;
        this.savedViewTransformer = vv.getViewTransformer();
        this.graphMouse = vv.getGraphMouse();
        this.defaultToolTipText = vv.getToolTipText();
        this.lensGraphMouse = lensGraphMouse;
    }

    public void activate(boolean state) {
        if (state) {
            this.activate();
        } else {
            this.deactivate();
        }
    }

    public LensTransformer getLensTransformer() {
        return this.lensTransformer;
    }

    public ModalGraphMouse getGraphMouse() {
        return this.lensGraphMouse;
    }

    public static class LensControls
    implements VisualizationViewer.Paintable {
        LensTransformer lensTransformer;
        Ellipse2D ellipse;

        public LensControls(LensTransformer lensTransformer) {
            this.lensTransformer = lensTransformer;
            this.ellipse = lensTransformer.getEllipse();
        }

        public void paint(Graphics g) {
            Graphics2D g2d = (Graphics2D)g;
            g.setColor(Color.gray);
            g2d.draw(this.ellipse);
            int centerX = (int)Math.round(this.ellipse.getCenterX());
            int centerY = (int)Math.round(this.ellipse.getCenterY());
            g.setColor(Color.darkGray);
            g.drawOval(centerX - 10, centerY - 10, 20, 20);
            g.setColor(Color.gray);
            g.drawOval(centerX - 9, centerY - 9, 18, 18);
            g.setColor(Color.white);
            g.drawOval(centerX - 8, centerY - 8, 16, 16);
            g.setColor(Color.gray);
            g.drawOval(centerX - 7, centerY - 7, 14, 14);
            g.setColor(Color.darkGray);
            g.drawOval(centerX - 6, centerY - 6, 12, 12);
            g.setColor(Color.gray);
            g.fill3DRect(centerX - 4, centerY - 11, 8, 8, true);
        }

        public boolean useTransform() {
            return false;
        }
    }

    public static class Lens
    implements VisualizationViewer.Paintable {
        LensTransformer lensTransformer;
        Ellipse2D ellipse;

        public Lens(LensTransformer lensTransformer) {
            this.lensTransformer = lensTransformer;
            this.ellipse = lensTransformer.getEllipse();
        }

        public void paint(Graphics g) {
            Graphics2D g2d = (Graphics2D)g;
            g.setColor(Color.decode("0xdddddd"));
            g2d.fill(this.ellipse);
        }

        public boolean useTransform() {
            return false;
        }
    }
}

