/*
 * Decompiled with CFR 0.152.
 */
package samples.graph;

import edu.uci.ics.jung.graph.ArchetypeVertex;
import edu.uci.ics.jung.graph.Graph;
import edu.uci.ics.jung.graph.decorators.DefaultToolTipFunction;
import edu.uci.ics.jung.graph.decorators.EdgeShape;
import edu.uci.ics.jung.graph.decorators.VertexStringer;
import edu.uci.ics.jung.graph.impl.SparseGraph;
import edu.uci.ics.jung.visualization.AbstractLayout;
import edu.uci.ics.jung.visualization.DefaultSettableVertexLocationFunction;
import edu.uci.ics.jung.visualization.GraphZoomScrollPane;
import edu.uci.ics.jung.visualization.PluggableRenderer;
import edu.uci.ics.jung.visualization.Renderer;
import edu.uci.ics.jung.visualization.ShapePickSupport;
import edu.uci.ics.jung.visualization.StaticLayout;
import edu.uci.ics.jung.visualization.VisualizationViewer;
import edu.uci.ics.jung.visualization.control.CrossoverScalingControl;
import edu.uci.ics.jung.visualization.control.EditingModalGraphMouse;
import edu.uci.ics.jung.visualization.control.EditingPopupGraphMousePlugin;
import edu.uci.ics.jung.visualization.control.ModalGraphMouse;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.io.File;
import javax.imageio.ImageIO;
import javax.swing.AbstractAction;
import javax.swing.JApplet;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JOptionPane;
import javax.swing.JPanel;

public class GraphEditorDemo
extends JApplet
implements Printable {
    Graph graph;
    AbstractLayout layout;
    VisualizationViewer vv;
    DefaultSettableVertexLocationFunction vertexLocations = new DefaultSettableVertexLocationFunction();
    String instructions = "<html><h3>All Modes:</h3><ul><li>Right-click an empty area for <b>Create Vertex</b> popup<li>Right-click on a Vertex for <b>Delete Vertex</b> popup<li>Right-click on a Vertex for <b>Add Edge</b> menus <br>(if there are selected Vertices)<li>Right-click on an Edge for <b>Delete Edge</b> popup<li>Mousewheel scales with a crossover value of 1.0.<p>     - scales the graph layout when the combined scale is greater than 1<p>     - scales the graph view when the combined scale is less than 1</ul><h3>Editing Mode:</h3><ul><li>Left-click an empty area to create a new Vertex<li>Left-click on a Vertex and drag to another Vertex to create an Undirected Edge<li>Shift+Left-click on a Vertex and drag to another Vertex to create a Directed Edge</ul><h3>Picking Mode:</h3><ul><li>Mouse1 on a Vertex selects the vertex<li>Mouse1 elsewhere unselects all Vertices<li>Mouse1+Shift on a Vertex adds/removes Vertex selection<li>Mouse1+drag on a Vertex moves all selected Vertices<li>Mouse1+drag elsewhere selects Vertices in a region<li>Mouse1+Shift+drag adds selection of Vertices in a new region<li>Mouse1+CTRL on a Vertex selects the vertex and centers the display on it</ul><h3>Transforming Mode:</h3><ul><li>Mouse1+drag pans the graph<li>Mouse1+Shift+drag rotates the graph<li>Mouse1+CTRL(or Command)+drag shears the graph</ul></html>";

    public GraphEditorDemo() {
        this.graph = new SparseGraph();
        PluggableRenderer pr = new PluggableRenderer();
        this.layout = new StaticLayout(this.graph);
        this.layout.initialize(new Dimension(600, 600), this.vertexLocations);
        this.vv = new VisualizationViewer(this.layout, (Renderer)pr);
        this.vv.setBackground(Color.white);
        this.vv.setPickSupport(new ShapePickSupport());
        pr.setEdgeShapeFunction(new EdgeShape.QuadCurve());
        pr.setVertexStringer(new VertexStringer(){

            public String getLabel(ArchetypeVertex v) {
                return v.toString();
            }
        });
        this.vv.setToolTipFunction(new DefaultToolTipFunction());
        Container content = this.getContentPane();
        GraphZoomScrollPane panel = new GraphZoomScrollPane(this.vv);
        content.add(panel);
        EditingModalGraphMouse graphMouse = new EditingModalGraphMouse();
        graphMouse.setVertexLocations(this.vertexLocations);
        this.vv.setGraphMouse(graphMouse);
        graphMouse.add(new EditingPopupGraphMousePlugin(this.vertexLocations));
        graphMouse.setMode(ModalGraphMouse.Mode.EDITING);
        final CrossoverScalingControl scaler = new CrossoverScalingControl();
        JButton plus = new JButton("+");
        plus.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                scaler.scale(GraphEditorDemo.this.vv, 1.1f, GraphEditorDemo.this.vv.getCenter());
            }
        });
        JButton minus = new JButton("-");
        minus.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                scaler.scale(GraphEditorDemo.this.vv, 0.9f, GraphEditorDemo.this.vv.getCenter());
            }
        });
        JButton help = new JButton("Help");
        help.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                JOptionPane.showMessageDialog(GraphEditorDemo.this.vv, GraphEditorDemo.this.instructions);
            }
        });
        JPanel controls = new JPanel();
        controls.add(plus);
        controls.add(minus);
        JComboBox modeBox = graphMouse.getModeComboBox();
        controls.add(modeBox);
        controls.add(help);
        content.add((Component)controls, "South");
    }

    public void writeJPEGImage(File file) {
        int width = this.vv.getWidth();
        int height = this.vv.getHeight();
        BufferedImage bi = new BufferedImage(width, height, 1);
        Graphics2D graphics = bi.createGraphics();
        this.vv.paint(graphics);
        graphics.dispose();
        try {
            ImageIO.write((RenderedImage)bi, "jpeg", file);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public int print(Graphics graphics, PageFormat pageFormat, int pageIndex) throws PrinterException {
        if (pageIndex > 0) {
            return 1;
        }
        Graphics2D g2d = (Graphics2D)graphics;
        this.vv.setDoubleBuffered(false);
        g2d.translate(pageFormat.getImageableX(), pageFormat.getImageableY());
        this.vv.paint(g2d);
        this.vv.setDoubleBuffered(true);
        return 0;
    }

    public static void main(String[] args) {
        JFrame frame = new JFrame();
        frame.setDefaultCloseOperation(3);
        final GraphEditorDemo demo = new GraphEditorDemo();
        JMenu menu = new JMenu("File");
        menu.add(new AbstractAction("Make Image"){

            public void actionPerformed(ActionEvent e) {
                JFileChooser chooser = new JFileChooser();
                int option = chooser.showSaveDialog(demo);
                if (option == 0) {
                    File file = chooser.getSelectedFile();
                    demo.writeJPEGImage(file);
                }
            }
        });
        menu.add(new AbstractAction("Print"){

            public void actionPerformed(ActionEvent e) {
                PrinterJob printJob = PrinterJob.getPrinterJob();
                printJob.setPrintable(demo);
                if (printJob.printDialog()) {
                    try {
                        printJob.print();
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                }
            }
        });
        JMenuBar menuBar = new JMenuBar();
        menuBar.add(menu);
        frame.setJMenuBar(menuBar);
        frame.getContentPane().add(demo);
        frame.pack();
        frame.setVisible(true);
    }
}

