/*
 * Decompiled with CFR 0.152.
 */
package samples.graph;

import edu.uci.ics.jung.algorithms.importance.VoltageRanker;
import edu.uci.ics.jung.graph.DirectedEdge;
import edu.uci.ics.jung.graph.Edge;
import edu.uci.ics.jung.graph.Graph;
import edu.uci.ics.jung.graph.UndirectedEdge;
import edu.uci.ics.jung.graph.Vertex;
import edu.uci.ics.jung.graph.decorators.AbstractVertexShapeFunction;
import edu.uci.ics.jung.graph.decorators.ConstantEdgeStringer;
import edu.uci.ics.jung.graph.decorators.ConstantVertexStringer;
import edu.uci.ics.jung.graph.decorators.DefaultToolTipFunction;
import edu.uci.ics.jung.graph.decorators.EdgeFontFunction;
import edu.uci.ics.jung.graph.decorators.EdgePaintFunction;
import edu.uci.ics.jung.graph.decorators.EdgeShape;
import edu.uci.ics.jung.graph.decorators.EdgeStringer;
import edu.uci.ics.jung.graph.decorators.EdgeStrokeFunction;
import edu.uci.ics.jung.graph.decorators.GradientEdgePaintFunction;
import edu.uci.ics.jung.graph.decorators.NumberEdgeValue;
import edu.uci.ics.jung.graph.decorators.NumberEdgeValueStringer;
import edu.uci.ics.jung.graph.decorators.NumberVertexValue;
import edu.uci.ics.jung.graph.decorators.NumberVertexValueStringer;
import edu.uci.ics.jung.graph.decorators.PickableEdgePaintFunction;
import edu.uci.ics.jung.graph.decorators.UserDatumNumberEdgeValue;
import edu.uci.ics.jung.graph.decorators.UserDatumNumberVertexValue;
import edu.uci.ics.jung.graph.decorators.VertexAspectRatioFunction;
import edu.uci.ics.jung.graph.decorators.VertexFontFunction;
import edu.uci.ics.jung.graph.decorators.VertexPaintFunction;
import edu.uci.ics.jung.graph.decorators.VertexSizeFunction;
import edu.uci.ics.jung.graph.decorators.VertexStringer;
import edu.uci.ics.jung.graph.decorators.VertexStrokeFunction;
import edu.uci.ics.jung.graph.impl.AbstractSparseEdge;
import edu.uci.ics.jung.graph.impl.DirectedSparseEdge;
import edu.uci.ics.jung.graph.impl.UndirectedSparseEdge;
import edu.uci.ics.jung.graph.predicates.ContainsUserDataKeyVertexPredicate;
import edu.uci.ics.jung.graph.predicates.SelfLoopEdgePredicate;
import edu.uci.ics.jung.random.generators.BarabasiAlbertGenerator;
import edu.uci.ics.jung.utils.MutableDouble;
import edu.uci.ics.jung.utils.PredicateUtils;
import edu.uci.ics.jung.utils.TestGraphs;
import edu.uci.ics.jung.visualization.FRLayout;
import edu.uci.ics.jung.visualization.GraphZoomScrollPane;
import edu.uci.ics.jung.visualization.HasGraphLayout;
import edu.uci.ics.jung.visualization.PickSupport;
import edu.uci.ics.jung.visualization.PickedInfo;
import edu.uci.ics.jung.visualization.PickedState;
import edu.uci.ics.jung.visualization.PluggableRenderer;
import edu.uci.ics.jung.visualization.Renderer;
import edu.uci.ics.jung.visualization.ShapePickSupport;
import edu.uci.ics.jung.visualization.VisualizationViewer;
import edu.uci.ics.jung.visualization.control.AbstractPopupGraphMousePlugin;
import edu.uci.ics.jung.visualization.control.CrossoverScalingControl;
import edu.uci.ics.jung.visualization.control.DefaultModalGraphMouse;
import edu.uci.ics.jung.visualization.transform.LayoutTransformer;
import edu.uci.ics.jung.visualization.transform.Transformer;
import java.awt.BasicStroke;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GradientPaint;
import java.awt.GridLayout;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.geom.Point2D;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.JApplet;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButton;
import org.apache.commons.collections.Predicate;

public class PluggableRendererDemo
extends JApplet
implements ActionListener {
    protected JCheckBox v_color;
    protected JCheckBox e_color;
    protected JCheckBox v_stroke;
    protected JCheckBox e_uarrow_pred;
    protected JCheckBox e_darrow_pred;
    protected JCheckBox v_shape;
    protected JCheckBox v_size;
    protected JCheckBox v_aspect;
    protected JCheckBox v_labels;
    protected JRadioButton e_line;
    protected JRadioButton e_bent;
    protected JRadioButton e_wedge;
    protected JRadioButton e_quad;
    protected JRadioButton e_cubic;
    protected JCheckBox e_labels;
    protected JCheckBox font;
    protected JCheckBox e_show_d;
    protected JCheckBox e_show_u;
    protected JCheckBox v_small;
    protected JCheckBox zoom_at_mouse;
    protected JCheckBox fill_edges;
    protected JRadioButton no_gradient;
    protected JRadioButton gradient_relative;
    protected static final int GRADIENT_NONE = 0;
    protected static final int GRADIENT_RELATIVE = 1;
    protected static int gradient_level = 0;
    protected PluggableRenderer pr;
    protected SeedColor vcf;
    protected EdgeWeightStrokeFunction ewcs;
    protected VertexStrokeHighlight vsh;
    protected VertexStringer vs;
    protected VertexStringer vs_none;
    protected EdgeStringer es;
    protected EdgeStringer es_none;
    protected FontHandler ff;
    protected VertexShapeSizeAspect vssa;
    protected DirectionDisplayPredicate show_edge;
    protected DirectionDisplayPredicate show_arrow;
    protected VertexDisplayPredicate show_vertex;
    protected GradientPickedEdgePaintFunction edgePaint;
    protected static final Object VOLTAGE_KEY = "voltages";
    protected static final Object TRANSPARENCY = "transparency";
    protected NumberEdgeValue edge_weight = new UserDatumNumberEdgeValue("edge_weight");
    protected NumberVertexValue voltages = new UserDatumNumberVertexValue(VOLTAGE_KEY);
    protected NumberVertexValue transparency = new UserDatumNumberVertexValue(TRANSPARENCY);
    protected VisualizationViewer vv;
    protected DefaultModalGraphMouse gm;
    protected Transformer affineTransformer;

    public void start() {
        this.getContentPane().add(this.startFunction());
    }

    public static void main(String[] s) {
        JFrame jf = new JFrame();
        jf.setDefaultCloseOperation(3);
        JPanel jp = new PluggableRendererDemo().startFunction();
        jf.getContentPane().add(jp);
        jf.pack();
        jf.show();
    }

    public JPanel startFunction() {
        Graph g = this.getGraph();
        this.pr = new PluggableRenderer();
        FRLayout layout = new FRLayout(g);
        this.vv = new VisualizationViewer(layout, (Renderer)this.pr);
        this.vv.setPickSupport(new ShapePickSupport());
        PickedState picked_state = this.vv.getPickedState();
        this.affineTransformer = this.vv.getLayoutTransformer();
        this.vcf = new SeedColor(picked_state);
        this.ewcs = new EdgeWeightStrokeFunction(this.edge_weight);
        this.vsh = new VertexStrokeHighlight(picked_state);
        this.ff = new FontHandler();
        this.vs_none = new ConstantVertexStringer(null);
        this.es_none = new ConstantEdgeStringer(null);
        this.vssa = new VertexShapeSizeAspect(this.voltages);
        this.show_edge = new DirectionDisplayPredicate(true, true);
        this.show_arrow = new DirectionDisplayPredicate(true, false);
        this.show_vertex = new VertexDisplayPredicate(false);
        this.edgePaint = new GradientPickedEdgePaintFunction(new PickableEdgePaintFunction(picked_state, Color.black, Color.cyan), this.vv, this.vv, picked_state);
        this.pr.setVertexPaintFunction(this.vcf);
        this.pr.setVertexStrokeFunction(this.vsh);
        this.pr.setVertexStringer(this.vs_none);
        this.pr.setVertexFontFunction(this.ff);
        this.pr.setVertexShapeFunction(this.vssa);
        this.pr.setVertexIncludePredicate(this.show_vertex);
        this.pr.setEdgePaintFunction(this.edgePaint);
        this.pr.setEdgeStringer(this.es_none);
        this.pr.setEdgeFontFunction(this.ff);
        this.pr.setEdgeStrokeFunction(this.ewcs);
        this.pr.setEdgeIncludePredicate(this.show_edge);
        this.pr.setEdgeShapeFunction(new EdgeShape.Line());
        this.pr.setEdgeArrowPredicate(this.show_arrow);
        JPanel jp = new JPanel();
        jp.setLayout(new BorderLayout());
        this.vv.setBackground(Color.white);
        GraphZoomScrollPane scrollPane = new GraphZoomScrollPane(this.vv);
        jp.add(scrollPane);
        this.gm = new DefaultModalGraphMouse();
        this.vv.setGraphMouse(this.gm);
        this.gm.add(new PopupGraphMousePlugin());
        this.addBottomControls(jp);
        this.vssa.setScaling(true);
        this.vv.setToolTipFunction(new VoltageTips());
        this.vv.setToolTipText("<html><center>Use the mouse wheel to zoom<p>Click and Drag the mouse to pan<p>Shift-click and Drag to Rotate</center></html>");
        return jp;
    }

    public Graph getGraph() {
        Graph g = TestGraphs.generateMixedRandomGraph(this.edge_weight, 20, false);
        this.vs = new NumberVertexValueStringer(this.voltages);
        this.es = new NumberEdgeValueStringer(this.edge_weight);
        Set seeds = PredicateUtils.getVertices(g, new ContainsUserDataKeyVertexPredicate(BarabasiAlbertGenerator.SEED));
        if (seeds.size() < 2) {
            System.out.println("need at least 2 seeds (one source, one sink)");
        }
        boolean source = true;
        HashSet sources = new HashSet();
        HashSet sinks = new HashSet();
        Iterator iter = seeds.iterator();
        while (iter.hasNext()) {
            if (source) {
                sources.add(iter.next());
            } else {
                sinks.add(iter.next());
            }
            source = !source;
        }
        VoltageRanker vr = new VoltageRanker(this.edge_weight, this.voltages, 100, 0.01);
        vr.calculateVoltages(g, sources, sinks);
        Set verts = g.getVertices();
        Iterator iter2 = verts.iterator();
        while (iter2.hasNext()) {
            Vertex v = (Vertex)iter2.next();
            this.transparency.setNumber(v, new MutableDouble(0.9));
        }
        Vertex v = (Vertex)verts.iterator().next();
        AbstractSparseEdge e = new DirectedSparseEdge(v, v);
        this.edge_weight.setNumber(e, new Double(Math.random()));
        g.addEdge(e);
        e = new UndirectedSparseEdge(v, v);
        this.edge_weight.setNumber(e, new Double(Math.random()));
        g.addEdge(e);
        return g;
    }

    protected void addBottomControls(JPanel jp) {
        JPanel control_panel = new JPanel();
        jp.add((Component)control_panel, "South");
        control_panel.setLayout(new BorderLayout());
        Box vertex_panel = Box.createVerticalBox();
        vertex_panel.setBorder(BorderFactory.createTitledBorder("Vertices"));
        Box edge_panel = Box.createVerticalBox();
        edge_panel.setBorder(BorderFactory.createTitledBorder("Edges"));
        Box both_panel = Box.createVerticalBox();
        control_panel.add((Component)vertex_panel, "West");
        control_panel.add((Component)edge_panel, "East");
        control_panel.add((Component)both_panel, "Center");
        this.v_color = new JCheckBox("vertex seed coloring");
        this.v_color.addActionListener(this);
        this.v_stroke = new JCheckBox("<html>vertex selection<p>stroke highlighting</html>");
        this.v_stroke.addActionListener(this);
        this.v_labels = new JCheckBox("show vertex ranks (voltages)");
        this.v_labels.addActionListener(this);
        this.v_shape = new JCheckBox("vertex degree shapes");
        this.v_shape.addActionListener(this);
        this.v_size = new JCheckBox("vertex voltage size");
        this.v_size.addActionListener(this);
        this.v_size.setSelected(true);
        this.v_aspect = new JCheckBox("vertex degree ratio stretch");
        this.v_aspect.addActionListener(this);
        this.v_small = new JCheckBox("filter vertices of degree < 4");
        this.v_small.addActionListener(this);
        vertex_panel.add(this.v_color);
        vertex_panel.add(this.v_stroke);
        vertex_panel.add(this.v_labels);
        vertex_panel.add(this.v_shape);
        vertex_panel.add(this.v_size);
        vertex_panel.add(this.v_aspect);
        vertex_panel.add(this.v_small);
        JPanel gradient_panel = new JPanel(new GridLayout(1, 0));
        gradient_panel.setBorder(BorderFactory.createTitledBorder("Edge paint"));
        this.no_gradient = new JRadioButton("Solid color");
        this.no_gradient.addActionListener(this);
        this.no_gradient.setSelected(true);
        this.gradient_relative = new JRadioButton("Gradient");
        this.gradient_relative.addActionListener(this);
        ButtonGroup bg_grad = new ButtonGroup();
        bg_grad.add(this.no_gradient);
        bg_grad.add(this.gradient_relative);
        gradient_panel.add(this.no_gradient);
        gradient_panel.add(this.gradient_relative);
        JPanel shape_panel = new JPanel(new GridLayout(3, 2));
        shape_panel.setBorder(BorderFactory.createTitledBorder("Edge shape"));
        this.e_line = new JRadioButton("line");
        this.e_line.addActionListener(this);
        this.e_line.setSelected(true);
        this.e_wedge = new JRadioButton("wedge");
        this.e_wedge.addActionListener(this);
        this.e_quad = new JRadioButton("quad curve");
        this.e_quad.addActionListener(this);
        this.e_cubic = new JRadioButton("cubic curve");
        this.e_cubic.addActionListener(this);
        ButtonGroup bg_shape = new ButtonGroup();
        bg_shape.add(this.e_line);
        bg_shape.add(this.e_wedge);
        bg_shape.add(this.e_quad);
        bg_shape.add(this.e_cubic);
        shape_panel.add(this.e_line);
        shape_panel.add(this.e_wedge);
        shape_panel.add(this.e_quad);
        shape_panel.add(this.e_cubic);
        this.fill_edges = new JCheckBox("fill edge shapes");
        this.fill_edges.setSelected(false);
        this.fill_edges.addActionListener(this);
        shape_panel.add(this.fill_edges);
        shape_panel.setOpaque(true);
        this.e_color = new JCheckBox("edge weight highlighting");
        this.e_color.addActionListener(this);
        this.e_labels = new JCheckBox("show edge weights");
        this.e_labels.addActionListener(this);
        this.e_uarrow_pred = new JCheckBox("undirected");
        this.e_uarrow_pred.addActionListener(this);
        this.e_darrow_pred = new JCheckBox("directed");
        this.e_darrow_pred.addActionListener(this);
        this.e_darrow_pred.setSelected(true);
        JPanel arrow_panel = new JPanel(new GridLayout(1, 0));
        arrow_panel.setBorder(BorderFactory.createTitledBorder("Show arrows"));
        arrow_panel.add(this.e_uarrow_pred);
        arrow_panel.add(this.e_darrow_pred);
        this.e_show_d = new JCheckBox("directed");
        this.e_show_d.addActionListener(this);
        this.e_show_d.setSelected(true);
        this.e_show_u = new JCheckBox("undirected");
        this.e_show_u.addActionListener(this);
        this.e_show_u.setSelected(true);
        JPanel show_edge_panel = new JPanel(new GridLayout(1, 0));
        show_edge_panel.setBorder(BorderFactory.createTitledBorder("Show edges"));
        show_edge_panel.add(this.e_show_u);
        show_edge_panel.add(this.e_show_d);
        shape_panel.setAlignmentX(0.0f);
        edge_panel.add(shape_panel);
        gradient_panel.setAlignmentX(0.0f);
        edge_panel.add(gradient_panel);
        show_edge_panel.setAlignmentX(0.0f);
        edge_panel.add(show_edge_panel);
        arrow_panel.setAlignmentX(0.0f);
        edge_panel.add(arrow_panel);
        this.e_color.setAlignmentX(0.0f);
        edge_panel.add(this.e_color);
        this.e_labels.setAlignmentX(0.0f);
        edge_panel.add(this.e_labels);
        this.zoom_at_mouse = new JCheckBox("<html><center>zoom at mouse<p>(wheel only)</center></html>");
        this.zoom_at_mouse.addActionListener(this);
        final CrossoverScalingControl scaler = new CrossoverScalingControl();
        JButton plus = new JButton("+");
        plus.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                scaler.scale(PluggableRendererDemo.this.vv, 1.1f, PluggableRendererDemo.this.vv.getCenter());
            }
        });
        JButton minus = new JButton("-");
        minus.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                scaler.scale(PluggableRendererDemo.this.vv, 0.9f, PluggableRendererDemo.this.vv.getCenter());
            }
        });
        Box zoomPanel = Box.createVerticalBox();
        zoomPanel.setBorder(BorderFactory.createTitledBorder("Zoom"));
        plus.setAlignmentX(0.5f);
        zoomPanel.add(plus);
        minus.setAlignmentX(0.5f);
        zoomPanel.add(minus);
        this.zoom_at_mouse.setAlignmentX(0.5f);
        zoomPanel.add(this.zoom_at_mouse);
        this.font = new JCheckBox("bold text");
        this.font.addActionListener(this);
        this.font.setAlignmentX(0.5f);
        both_panel.add(zoomPanel);
        both_panel.add(this.font);
        JComboBox modeBox = this.gm.getModeComboBox();
        modeBox.setAlignmentX(0.5f);
        JPanel modePanel = new JPanel(new BorderLayout()){

            public Dimension getMaximumSize() {
                return this.getPreferredSize();
            }
        };
        modePanel.setBorder(BorderFactory.createTitledBorder("Mouse Mode"));
        modePanel.add(modeBox);
        both_panel.add(modePanel);
    }

    public void actionPerformed(ActionEvent e) {
        AbstractButton source = (AbstractButton)e.getSource();
        if (source == this.v_color) {
            this.vcf.setSeedColoring(source.isSelected());
        } else if (source == this.e_color) {
            this.ewcs.setWeighted(source.isSelected());
        } else if (source == this.v_stroke) {
            this.vsh.setHighlight(source.isSelected());
        } else if (source == this.v_labels) {
            if (source.isSelected()) {
                this.pr.setVertexStringer(this.vs);
            } else {
                this.pr.setVertexStringer(this.vs_none);
            }
        } else if (source == this.e_labels) {
            if (source.isSelected()) {
                this.pr.setEdgeStringer(this.es);
            } else {
                this.pr.setEdgeStringer(this.es_none);
            }
        } else if (source == this.e_uarrow_pred) {
            this.show_arrow.showUndirected(source.isSelected());
        } else if (source == this.e_darrow_pred) {
            this.show_arrow.showDirected(source.isSelected());
        } else if (source == this.font) {
            this.ff.setBold(source.isSelected());
        } else if (source == this.v_shape) {
            this.vssa.useFunnyShapes(source.isSelected());
        } else if (source == this.v_size) {
            this.vssa.setScaling(source.isSelected());
        } else if (source == this.v_aspect) {
            this.vssa.setStretching(source.isSelected());
        } else if (source == this.e_line) {
            if (source.isSelected()) {
                this.pr.setEdgeShapeFunction(new EdgeShape.Line());
            }
        } else if (source == this.e_wedge) {
            if (source.isSelected()) {
                this.pr.setEdgeShapeFunction(new EdgeShape.Wedge(10));
            }
        } else if (source == this.e_quad) {
            if (source.isSelected()) {
                this.pr.setEdgeShapeFunction(new EdgeShape.QuadCurve());
            }
        } else if (source == this.e_cubic) {
            if (source.isSelected()) {
                this.pr.setEdgeShapeFunction(new EdgeShape.CubicCurve());
            }
        } else if (source == this.e_show_d) {
            this.show_edge.showDirected(source.isSelected());
        } else if (source == this.e_show_u) {
            this.show_edge.showUndirected(source.isSelected());
        } else if (source == this.v_small) {
            this.show_vertex.filterSmall(source.isSelected());
        } else if (source == this.zoom_at_mouse) {
            this.gm.setZoomAtMouse(source.isSelected());
        } else if (source == this.no_gradient) {
            if (source.isSelected()) {
                gradient_level = 0;
            }
        } else if (source == this.gradient_relative) {
            if (source.isSelected()) {
                gradient_level = 1;
            }
        } else if (source == this.fill_edges) {
            this.edgePaint.useFill(source.isSelected());
        }
        this.vv.repaint();
    }

    public class GradientPickedEdgePaintFunction
    extends GradientEdgePaintFunction {
        private PickedInfo pi;
        private EdgePaintFunction defaultFunc;
        private final Predicate self_loop = SelfLoopEdgePredicate.getInstance();
        protected boolean fill_edge = false;

        public GradientPickedEdgePaintFunction(EdgePaintFunction defaultEdgePaintFunction, HasGraphLayout vv, LayoutTransformer transformer, PickedInfo pi) {
            super(Color.WHITE, Color.BLACK, vv, transformer);
            this.defaultFunc = defaultEdgePaintFunction;
            this.pi = pi;
        }

        public void useFill(boolean b) {
            this.fill_edge = b;
        }

        public Paint getDrawPaint(Edge e) {
            if (gradient_level == 0) {
                return this.defaultFunc.getDrawPaint(e);
            }
            return super.getDrawPaint(e);
        }

        protected Color getColor2(Edge e) {
            return this.pi.isPicked(e) ? Color.CYAN : this.c2;
        }

        public Paint getFillPaint(Edge e) {
            if (this.self_loop.evaluate((Object)e) || !this.fill_edge) {
                return null;
            }
            return this.getDrawPaint(e);
        }
    }

    public class VoltageTips
    extends DefaultToolTipFunction {
        public String getToolTipText(Vertex v) {
            return "Voltage:" + PluggableRendererDemo.this.voltages.getNumber(v);
        }

        public String getToolTipText(Edge edge) {
            return edge.toString();
        }
    }

    protected class PopupGraphMousePlugin
    extends AbstractPopupGraphMousePlugin
    implements MouseListener {
        public PopupGraphMousePlugin() {
            this(4);
        }

        public PopupGraphMousePlugin(int modifiers) {
            super(modifiers);
        }

        protected void handlePopup(MouseEvent e) {
            VisualizationViewer vv = (VisualizationViewer)e.getSource();
            Point2D p = vv.inverseViewTransform(e.getPoint());
            PickSupport pickSupport = vv.getPickSupport();
            if (pickSupport != null) {
                Vertex v = pickSupport.getVertex(p.getX(), p.getY());
                if (v != null) {
                    JPopupMenu popup = new JPopupMenu();
                    popup.add(new AbstractAction(this, "Decrease Transparency", v, vv){
                        private final /* synthetic */ Vertex val$v;
                        private final /* synthetic */ VisualizationViewer val$vv;
                        private final /* synthetic */ PopupGraphMousePlugin this$1;
                        {
                            this.this$1 = this$1;
                            this.val$v = val$v;
                            this.val$vv = val$vv;
                        }

                        public void actionPerformed(ActionEvent e) {
                            MutableDouble value = (MutableDouble)PopupGraphMousePlugin.access$100((PopupGraphMousePlugin)this.this$1).transparency.getNumber(this.val$v);
                            value.setDoubleValue(Math.min(1.0, value.doubleValue() + 0.1));
                            this.val$vv.repaint();
                        }
                    });
                    popup.add(new AbstractAction(this, "Increase Transparency", v, vv){
                        private final /* synthetic */ Vertex val$v;
                        private final /* synthetic */ VisualizationViewer val$vv;
                        private final /* synthetic */ PopupGraphMousePlugin this$1;
                        {
                            this.this$1 = this$1;
                            this.val$v = val$v;
                            this.val$vv = val$vv;
                        }

                        public void actionPerformed(ActionEvent e) {
                            MutableDouble value = (MutableDouble)PopupGraphMousePlugin.access$100((PopupGraphMousePlugin)this.this$1).transparency.getNumber(this.val$v);
                            value.setDoubleValue(Math.max(0.0, value.doubleValue() - 0.1));
                            this.val$vv.repaint();
                        }
                    });
                    popup.show(vv, e.getX(), e.getY());
                } else {
                    Edge edge = pickSupport.getEdge(p.getX(), p.getY());
                    if (edge != null) {
                        JPopupMenu popup = new JPopupMenu();
                        popup.add(new AbstractAction(this, edge.toString(), edge){
                            private final /* synthetic */ Edge val$edge;
                            private final /* synthetic */ PopupGraphMousePlugin this$1;
                            {
                                this.this$1 = this$1;
                                this.val$edge = val$edge;
                            }

                            public void actionPerformed(ActionEvent e) {
                                System.err.println("got " + this.val$edge);
                            }
                        });
                        popup.show(vv, e.getX(), e.getY());
                    }
                }
            }
        }

        static /* synthetic */ PluggableRendererDemo access$100(PopupGraphMousePlugin x0) {
            return x0.PluggableRendererDemo.this;
        }
    }

    private static final class VertexShapeSizeAspect
    extends AbstractVertexShapeFunction
    implements VertexSizeFunction,
    VertexAspectRatioFunction {
        protected boolean stretch = false;
        protected boolean scale = false;
        protected boolean funny_shapes = false;
        protected NumberVertexValue voltages;

        public VertexShapeSizeAspect(NumberVertexValue voltages) {
            this.voltages = voltages;
            this.setSizeFunction(this);
            this.setAspectRatioFunction(this);
        }

        public void setStretching(boolean stretch) {
            this.stretch = stretch;
        }

        public void setScaling(boolean scale) {
            this.scale = scale;
        }

        public void useFunnyShapes(boolean use) {
            this.funny_shapes = use;
        }

        public int getSize(Vertex v) {
            if (this.scale) {
                return (int)(this.voltages.getNumber(v).doubleValue() * 30.0) + 20;
            }
            return 20;
        }

        public float getAspectRatio(Vertex v) {
            if (this.stretch) {
                return (float)(v.inDegree() + 1) / (float)(v.outDegree() + 1);
            }
            return 1.0f;
        }

        public Shape getShape(Vertex v) {
            if (this.funny_shapes) {
                if (v.degree() < 5) {
                    int sides = Math.max(v.degree(), 3);
                    return this.factory.getRegularPolygon(v, sides);
                }
                return this.factory.getRegularStar(v, v.degree());
            }
            return this.factory.getEllipse(v);
        }
    }

    private static final class VertexDisplayPredicate
    implements Predicate {
        protected boolean filter_small;
        protected static final int MIN_DEGREE = 4;

        public VertexDisplayPredicate(boolean filter) {
            this.filter_small = filter;
        }

        public void filterSmall(boolean b) {
            this.filter_small = b;
        }

        public boolean evaluate(Object arg0) {
            Vertex v = (Vertex)arg0;
            if (this.filter_small) {
                return v.degree() >= 4;
            }
            return true;
        }
    }

    private static final class DirectionDisplayPredicate
    implements Predicate {
        protected boolean show_d;
        protected boolean show_u;

        public DirectionDisplayPredicate(boolean show_d, boolean show_u) {
            this.show_d = show_d;
            this.show_u = show_u;
        }

        public void showDirected(boolean b) {
            this.show_d = b;
        }

        public void showUndirected(boolean b) {
            this.show_u = b;
        }

        public boolean evaluate(Object arg0) {
            if (arg0 instanceof DirectedEdge && this.show_d) {
                return true;
            }
            return arg0 instanceof UndirectedEdge && this.show_u;
        }
    }

    private static final class FontHandler
    implements VertexFontFunction,
    EdgeFontFunction {
        protected boolean bold = false;
        Font f = new Font("Helvetica", 0, 12);
        Font b = new Font("Helvetica", 1, 12);

        private FontHandler() {
        }

        public void setBold(boolean bold) {
            this.bold = bold;
        }

        public Font getFont(Vertex v) {
            if (this.bold) {
                return this.b;
            }
            return this.f;
        }

        public Font getFont(Edge e) {
            if (this.bold) {
                return this.b;
            }
            return this.f;
        }
    }

    private static final class VertexStrokeHighlight
    implements VertexStrokeFunction {
        protected boolean highlight = false;
        protected Stroke heavy = new BasicStroke(5.0f);
        protected Stroke medium = new BasicStroke(3.0f);
        protected Stroke light = new BasicStroke(1.0f);
        protected PickedInfo pi;

        public VertexStrokeHighlight(PickedInfo pi) {
            this.pi = pi;
        }

        public void setHighlight(boolean highlight) {
            this.highlight = highlight;
        }

        public Stroke getStroke(Vertex v) {
            if (this.highlight) {
                if (this.pi.isPicked(v)) {
                    return this.heavy;
                }
                Iterator iter = v.getNeighbors().iterator();
                while (iter.hasNext()) {
                    Vertex w = (Vertex)iter.next();
                    if (!this.pi.isPicked(w)) continue;
                    return this.medium;
                }
                return this.light;
            }
            return this.light;
        }
    }

    private static final class EdgeWeightStrokeFunction
    implements EdgeStrokeFunction {
        protected static final Stroke basic = new BasicStroke(1.0f);
        protected static final Stroke heavy = new BasicStroke(2.0f);
        protected static final Stroke dotted = PluggableRenderer.DOTTED;
        protected boolean weighted = false;
        protected NumberEdgeValue edge_weight;

        public EdgeWeightStrokeFunction(NumberEdgeValue edge_weight) {
            this.edge_weight = edge_weight;
        }

        public void setWeighted(boolean weighted) {
            this.weighted = weighted;
        }

        public Stroke getStroke(Edge e) {
            if (this.weighted) {
                if (this.drawHeavy(e)) {
                    return heavy;
                }
                return dotted;
            }
            return basic;
        }

        protected boolean drawHeavy(Edge e) {
            double value = this.edge_weight.getNumber(e).doubleValue();
            return value > 0.7;
        }
    }

    private final class SeedColor
    implements VertexPaintFunction {
        protected PickedInfo pi;
        protected static final float dark_value = 0.8f;
        protected static final float light_value = 0.2f;
        protected boolean seed_coloring;

        public SeedColor(PickedInfo pi) {
            this.pi = pi;
            this.seed_coloring = false;
        }

        public void setSeedColoring(boolean b) {
            this.seed_coloring = b;
        }

        public Paint getDrawPaint(Vertex v) {
            return Color.BLACK;
        }

        public Paint getFillPaint(Vertex v) {
            float alpha = PluggableRendererDemo.this.transparency.getNumber(v).floatValue();
            if (this.pi.isPicked(v)) {
                return new Color(1.0f, 1.0f, 0.0f, alpha);
            }
            if (this.seed_coloring && v.containsUserDatumKey(BarabasiAlbertGenerator.SEED)) {
                Color dark = new Color(0.0f, 0.0f, 0.8f, alpha);
                Color light = new Color(0.0f, 0.0f, 0.2f, alpha);
                return new GradientPaint(0.0f, 0.0f, dark, 10.0f, 0.0f, light, true);
            }
            return new Color(1.0f, 0.0f, 0.0f, alpha);
        }
    }
}

