/*
 * Decompiled with CFR 0.152.
 */
package samples.graph.southern;

import edu.uci.ics.jung.algorithms.transformation.FoldingTransformer;
import edu.uci.ics.jung.graph.Graph;
import edu.uci.ics.jung.graph.KPartiteGraph;
import edu.uci.ics.jung.graph.Vertex;
import edu.uci.ics.jung.graph.decorators.StringLabeller;
import edu.uci.ics.jung.io.BipartiteGraphReader;
import edu.uci.ics.jung.utils.PredicateUtils;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.TreeSet;
import javax.swing.JFrame;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import samples.graph.southern.BipartiteVertexRenderer;
import samples.graph.southern.ThickEdgeRenderer;
import samples.preview_new_graphdraw.event.ClickEvent;
import samples.preview_new_graphdraw.event.ClickListener;
import samples.preview_new_graphdraw.impl.SimpleEdgeRenderer;
import samples.preview_new_graphdraw.iter.LocalGraphDraw;
import samples.preview_new_graphdraw.iterablelayouts.KKLayout;
import samples.preview_new_graphdraw.iterablelayouts.SpringLayout;
import samples.preview_new_graphdraw.staticlayouts.CircleLayout;
import samples.preview_new_graphdraw.staticlayouts.RandomLayout;

public class TestSouthernWomenBipartite
extends JPanel {
    private StringLabeller dates;
    private StringLabeller women;
    private KPartiteGraph bpg;
    private FoldingTransformer kpf;
    private JPanel bipartitePanel;
    private LocalGraphDraw bipartiteGraphDraw;
    static DateFormat df = new SimpleDateFormat("d-MMM", Locale.US);
    private BipartiteVertexRenderer wellKnownRenderer;

    public TestSouthernWomenBipartite(Reader fr) throws IOException {
        BipartiteGraphReader bgr = new BipartiteGraphReader(true, false, false);
        this.bpg = bgr.load(fr);
        System.out.println("loaded");
        this.women = StringLabeller.getLabeller(this.bpg, BipartiteGraphReader.PART_A);
        this.dates = StringLabeller.getLabeller(this.bpg, BipartiteGraphReader.PART_B);
        LocalGraphDraw lgd = this.createVisualization();
        final JList jl = this.assembleList();
        this.kpf = new FoldingTransformer(false);
        this.createFoldedSpace(jl);
        lgd.getPanel().addClickListener(new ClickListener(){

            public void edgeClicked(ClickEvent ece) {
            }

            public void vertexClicked(ClickEvent vce) {
                Vertex v = (Vertex)vce.getGraphObject();
                String label = TestSouthernWomenBipartite.this.dates.getLabel(v);
                if (label != null) {
                    TestSouthernWomenBipartite.changeSelectLabel(label, jl);
                }
            }
        });
        JPanel right = new JPanel();
        right.add(jl);
        this.setLayout(new BorderLayout());
        JPanel core = new JPanel();
        core.add(lgd.getPanel());
        core.add(this.bipartitePanel);
        this.add((Component)core, "Center");
        this.add((Component)right, "East");
    }

    private static void changeSelectLabel(String label, JList jl) {
        LinkedList<Integer> integers = new LinkedList<Integer>();
        int i = -1;
        for (i = 0; i < jl.getModel().getSize(); ++i) {
            boolean shouldAdd = false;
            if (jl.isSelectedIndex(i)) {
                shouldAdd = true;
            }
            if (jl.getModel().getElementAt(i).equals(label)) {
                boolean bl = shouldAdd = !shouldAdd;
            }
            if (!shouldAdd) continue;
            integers.add(new Integer(i));
        }
        int[] selections = new int[integers.size()];
        int j = 0;
        Iterator iter = integers.iterator();
        while (iter.hasNext()) {
            Integer ii = (Integer)iter.next();
            selections[j++] = ii;
        }
        jl.setValueIsAdjusting(true);
        jl.setSelectedIndices(selections);
        jl.setValueIsAdjusting(false);
    }

    private void createFoldedSpace(JList jl) {
        jl.addListSelectionListener(new RemoveAndRefold(this.bpg));
        this.bipartitePanel = new JPanel();
        this.foldAndDisplay(this.bpg);
    }

    void foldAndDisplay(KPartiteGraph bpgx) {
        KPartiteGraph bpg2 = bpgx;
        Graph f = this.kpf.fold(bpg2, BipartiteGraphReader.PART_A);
        ThickEdgeRenderer er = new ThickEdgeRenderer(Color.lightGray);
        BipartiteVertexRenderer vr = new BipartiteVertexRenderer(bpg2, this.women, this.dates);
        Dimension d = new Dimension(450, 450);
        if (this.bipartiteGraphDraw != null) {
            this.bipartiteGraphDraw.stop();
            this.bipartitePanel.removeAll();
        }
        this.bipartiteGraphDraw = new LocalGraphDraw(f, new CircleLayout(), new SpringLayout(), vr, er, d, true);
        this.bipartiteGraphDraw.start();
        this.bipartitePanel.add(this.bipartiteGraphDraw.getPanel());
    }

    public static void main(String[] s) {
        try {
            FileReader fr = new FileReader("samples/datasets/southern_women_data.txt");
            System.out.println("loading : ");
            TestSouthernWomenBipartite jp = new TestSouthernWomenBipartite(fr);
            JFrame jf = new JFrame();
            jf.getContentPane().add(jp);
            jf.pack();
            jf.show();
            jf.setDefaultCloseOperation(3);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private JList assembleList() {
        try {
            List listOfDates = this.getListOfDates();
            ArrayList<String> displayList = new ArrayList<String>();
            Iterator iter = listOfDates.iterator();
            while (iter.hasNext()) {
                Date d = (Date)iter.next();
                displayList.add(df.format(d));
            }
            return new JList<Object>(displayList.toArray());
        }
        catch (Exception e) {
            System.out.println(e);
            return null;
        }
    }

    private List getListOfDates() throws ParseException {
        TreeSet<Date> s = new TreeSet<Date>();
        Set dates_part = PredicateUtils.getVertices(this.bpg, BipartiteGraphReader.PART_B);
        Iterator iter = dates_part.iterator();
        while (iter.hasNext()) {
            Vertex v = (Vertex)iter.next();
            String label = this.dates.getLabel(v);
            Date d = df.parse(label);
            s.add(d);
        }
        LinkedList l = new LinkedList(s);
        return l;
    }

    protected static void dumpNames(KPartiteGraph bpg, StringLabeller women, StringLabeller dates) {
        Iterator iter = PredicateUtils.getVertices(bpg, BipartiteGraphReader.PART_A).iterator();
        while (iter.hasNext()) {
            Vertex bpv = (Vertex)iter.next();
            System.out.println(women.getLabel(bpv) + " (" + bpv.getNeighbors().size());
            Iterator iterator = bpv.getNeighbors().iterator();
            while (iterator.hasNext()) {
                Vertex bpv2 = (Vertex)iterator.next();
                System.out.println(" " + dates.getLabel(bpv2));
            }
        }
    }

    private LocalGraphDraw createVisualization() {
        SimpleEdgeRenderer er = new SimpleEdgeRenderer(Color.lightGray);
        this.wellKnownRenderer = new BipartiteVertexRenderer(this.bpg, this.women, this.dates);
        Dimension d = new Dimension(450, 450);
        LocalGraphDraw lgd = new LocalGraphDraw(this.bpg, new RandomLayout(), new KKLayout(), this.wellKnownRenderer, er, d, true);
        lgd.start();
        return lgd;
    }

    public class RemoveAndRefold
    implements ListSelectionListener {
        private KPartiteGraph kpg;

        public RemoveAndRefold(KPartiteGraph kpg) {
            this.kpg = kpg;
        }

        public void valueChanged(ListSelectionEvent e) {
            JList jl = (JList)e.getSource();
            if (jl.getSelectionModel().getValueIsAdjusting()) {
                return;
            }
            KPartiteGraph bpg2 = (KPartiteGraph)this.kpg.copy();
            Object[] selected = jl.getSelectedValues();
            for (int i = 0; i < selected.length; ++i) {
                Vertex v2 = TestSouthernWomenBipartite.this.dates.getVertex((String)selected[i]);
                if (v2 == null) {
                    System.out.println("No original vertex with label " + selected[i]);
                }
                bpg2.removeVertex((Vertex)v2.getEqualVertex(bpg2));
            }
            TestSouthernWomenBipartite.this.wellKnownRenderer.setHiddenList(Arrays.asList(selected));
            TestSouthernWomenBipartite.this.foldAndDisplay(bpg2);
        }
    }
}

