/*
 * Decompiled with CFR 0.152.
 */
package org.jrobin.graph;

import java.awt.Point;
import java.io.IOException;
import java.io.OutputStream;
import org.jrobin.graph.GifPixelsEncoder;
import org.jrobin.graph.Put;

abstract class Gif89Frame {
    static final int DM_UNDEFINED = 0;
    static final int DM_LEAVE = 1;
    static final int DM_BGCOLOR = 2;
    static final int DM_REVERT = 3;
    int theWidth = -1;
    int theHeight = -1;
    byte[] ciPixels;
    private Point thePosition = new Point(0, 0);
    private boolean isInterlaced;
    private int csecsDelay;
    private int disposalCode = 1;

    void setPosition(Point point) {
        this.thePosition = new Point(point);
    }

    void setInterlaced(boolean bl) {
        this.isInterlaced = bl;
    }

    void setDelay(int n) {
        this.csecsDelay = n;
    }

    void setDisposalMode(int n) {
        this.disposalCode = n;
    }

    Gif89Frame() {
    }

    abstract Object getPixelSource();

    int getWidth() {
        return this.theWidth;
    }

    int getHeight() {
        return this.theHeight;
    }

    byte[] getPixelSink() {
        return this.ciPixels;
    }

    void encode(OutputStream outputStream, boolean bl, int n, int n2) throws IOException {
        this.writeGraphicControlExtension(outputStream, bl, n2);
        this.writeImageDescriptor(outputStream);
        new GifPixelsEncoder(this.theWidth, this.theHeight, this.ciPixels, this.isInterlaced, n).encode(outputStream);
    }

    private void writeGraphicControlExtension(OutputStream outputStream, boolean bl, int n) throws IOException {
        int n2;
        int n3 = n2 = n == -1 ? 0 : 1;
        if (n2 == 1 || bl) {
            outputStream.write(33);
            outputStream.write(249);
            outputStream.write(4);
            outputStream.write(this.disposalCode << 2 | n2);
            Put.leShort(this.csecsDelay, outputStream);
            outputStream.write(n);
            outputStream.write(0);
        }
    }

    private void writeImageDescriptor(OutputStream outputStream) throws IOException {
        outputStream.write(44);
        Put.leShort(this.thePosition.x, outputStream);
        Put.leShort(this.thePosition.y, outputStream);
        Put.leShort(this.theWidth, outputStream);
        Put.leShort(this.theHeight, outputStream);
        outputStream.write(this.isInterlaced ? 64 : 0);
    }
}

